// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.cloudfront.model.CloudFrontException
import aws.sdk.kotlin.services.cloudfront.model.CreateOriginRequestPolicyResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer


internal class CreateOriginRequestPolicyOperationDeserializer: HttpDeserialize<CreateOriginRequestPolicyResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateOriginRequestPolicyResponse {
        if (!response.status.isSuccess()) {
            throwCreateOriginRequestPolicyError(context, response)
        }
        val builder = CreateOriginRequestPolicyResponse.builder()

        builder.eTag = response.headers["ETag"]
        builder.location = response.headers["Location"]

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateOriginRequestPolicyOperationBody(builder, payload)
        }

        return builder.build()
    }
}

private suspend fun deserializeCreateOriginRequestPolicyOperationBody(builder: CreateOriginRequestPolicyResponse.DslBuilder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    builder.originRequestPolicy = deserializeOriginRequestPolicyDocument(deserializer)
}

private suspend fun throwCreateOriginRequestPolicyError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as restXml error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "AccessDenied" -> AccessDeniedDeserializer()
        "InconsistentQuantities" -> InconsistentQuantitiesDeserializer()
        "InvalidArgument" -> InvalidArgumentDeserializer()
        "OriginRequestPolicyAlreadyExists" -> OriginRequestPolicyAlreadyExistsDeserializer()
        "TooManyCookiesInOriginRequestPolicy" -> TooManyCookiesInOriginRequestPolicyDeserializer()
        "TooManyHeadersInOriginRequestPolicy" -> TooManyHeadersInOriginRequestPolicyDeserializer()
        "TooManyOriginRequestPolicies" -> TooManyOriginRequestPoliciesDeserializer()
        "TooManyQueryStringsInOriginRequestPolicy" -> TooManyQueryStringsInOriginRequestPolicyDeserializer()
        else -> throw CloudFrontException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
