// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.transform

import aws.sdk.kotlin.services.cloudfront.model.CreateInvalidationRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName
import aws.smithy.kotlin.runtime.serde.xml.XmlSerializer


internal class CreateInvalidationOperationSerializer: HttpSerialize<CreateInvalidationRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateInvalidationRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf(
                "2020-05-31",
                "distribution",
                "${input.distributionId}".encodeLabel(),
                "invalidation",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        if (input.invalidationBatch != null) {
            val payload = serializeCreateInvalidationOperationBody(context, input)
            builder.body = ByteArrayContent(payload)
        }
        builder.headers.setMissing("Content-Type", "application/xml")
        return builder
    }
}

private fun serializeCreateInvalidationOperationBody(context: ExecutionContext, input: CreateInvalidationRequest): ByteArray {
    val serializer = XmlSerializer()
    val input = requireNotNull(input.invalidationBatch)
    val CALLERREFERENCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("CallerReference"))
    val PATHS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("Paths"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlSerialName("InvalidationBatch"))
        trait(XmlNamespace("http://cloudfront.amazonaws.com/doc/2020-05-31/"))
        field(CALLERREFERENCE_DESCRIPTOR)
        field(PATHS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.callerReference?.let { field(CALLERREFERENCE_DESCRIPTOR, it) }
        input.paths?.let { field(PATHS_DESCRIPTOR, it, ::serializePathsDocument) }
    }
    return serializer.toByteArray()
}
