// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.cloudfront.model.CloudFrontException
import aws.sdk.kotlin.services.cloudfront.model.CreateFieldLevelEncryptionConfigResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer


internal class CreateFieldLevelEncryptionConfigOperationDeserializer: HttpDeserialize<CreateFieldLevelEncryptionConfigResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateFieldLevelEncryptionConfigResponse {
        if (!response.status.isSuccess()) {
            throwCreateFieldLevelEncryptionConfigError(context, response)
        }
        val builder = CreateFieldLevelEncryptionConfigResponse.builder()

        builder.eTag = response.headers["ETag"]
        builder.location = response.headers["Location"]

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateFieldLevelEncryptionConfigOperationBody(builder, payload)
        }

        return builder.build()
    }
}

private suspend fun deserializeCreateFieldLevelEncryptionConfigOperationBody(builder: CreateFieldLevelEncryptionConfigResponse.DslBuilder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    builder.fieldLevelEncryption = deserializeFieldLevelEncryptionDocument(deserializer)
}

private suspend fun throwCreateFieldLevelEncryptionConfigError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as restXml error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "FieldLevelEncryptionConfigAlreadyExists" -> FieldLevelEncryptionConfigAlreadyExistsDeserializer()
        "InconsistentQuantities" -> InconsistentQuantitiesDeserializer()
        "InvalidArgument" -> InvalidArgumentDeserializer()
        "NoSuchFieldLevelEncryptionProfile" -> NoSuchFieldLevelEncryptionProfileDeserializer()
        "QueryArgProfileEmpty" -> QueryArgProfileEmptyDeserializer()
        "TooManyFieldLevelEncryptionConfigs" -> TooManyFieldLevelEncryptionConfigsDeserializer()
        "TooManyFieldLevelEncryptionContentTypeProfiles" -> TooManyFieldLevelEncryptionContentTypeProfilesDeserializer()
        "TooManyFieldLevelEncryptionQueryArgProfiles" -> TooManyFieldLevelEncryptionQueryArgProfilesDeserializer()
        else -> throw CloudFrontException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
