// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.cloudfront.model.CloudFrontException
import aws.sdk.kotlin.services.cloudfront.model.CreateDistributionWithTagsResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer


internal class CreateDistributionWithTagsOperationDeserializer: HttpDeserialize<CreateDistributionWithTagsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateDistributionWithTagsResponse {
        if (!response.status.isSuccess()) {
            throwCreateDistributionWithTagsError(context, response)
        }
        val builder = CreateDistributionWithTagsResponse.builder()

        builder.eTag = response.headers["ETag"]
        builder.location = response.headers["Location"]

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateDistributionWithTagsOperationBody(builder, payload)
        }

        return builder.build()
    }
}

private suspend fun deserializeCreateDistributionWithTagsOperationBody(builder: CreateDistributionWithTagsResponse.DslBuilder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    builder.distribution = deserializeDistributionDocument(deserializer)
}

private suspend fun throwCreateDistributionWithTagsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as restXml error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "AccessDenied" -> AccessDeniedDeserializer()
        "CNAMEAlreadyExists" -> CnameAlreadyExistsDeserializer()
        "DistributionAlreadyExists" -> DistributionAlreadyExistsDeserializer()
        "IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior" -> IllegalFieldLevelEncryptionConfigAssociationWithCacheBehaviorDeserializer()
        "InconsistentQuantities" -> InconsistentQuantitiesDeserializer()
        "InvalidArgument" -> InvalidArgumentDeserializer()
        "InvalidDefaultRootObject" -> InvalidDefaultRootObjectDeserializer()
        "InvalidErrorCode" -> InvalidErrorCodeDeserializer()
        "InvalidForwardCookies" -> InvalidForwardCookiesDeserializer()
        "InvalidFunctionAssociation" -> InvalidFunctionAssociationDeserializer()
        "InvalidGeoRestrictionParameter" -> InvalidGeoRestrictionParameterDeserializer()
        "InvalidHeadersForS3Origin" -> InvalidHeadersForS3OriginDeserializer()
        "InvalidLambdaFunctionAssociation" -> InvalidLambdaFunctionAssociationDeserializer()
        "InvalidLocationCode" -> InvalidLocationCodeDeserializer()
        "InvalidMinimumProtocolVersion" -> InvalidMinimumProtocolVersionDeserializer()
        "InvalidOrigin" -> InvalidOriginDeserializer()
        "InvalidOriginAccessIdentity" -> InvalidOriginAccessIdentityDeserializer()
        "InvalidOriginKeepaliveTimeout" -> InvalidOriginKeepaliveTimeoutDeserializer()
        "InvalidOriginReadTimeout" -> InvalidOriginReadTimeoutDeserializer()
        "InvalidProtocolSettings" -> InvalidProtocolSettingsDeserializer()
        "InvalidQueryStringParameters" -> InvalidQueryStringParametersDeserializer()
        "InvalidRelativePath" -> InvalidRelativePathDeserializer()
        "InvalidRequiredProtocol" -> InvalidRequiredProtocolDeserializer()
        "InvalidResponseCode" -> InvalidResponseCodeDeserializer()
        "InvalidTagging" -> InvalidTaggingDeserializer()
        "InvalidTTLOrder" -> InvalidTtlOrderDeserializer()
        "InvalidViewerCertificate" -> InvalidViewerCertificateDeserializer()
        "InvalidWebACLId" -> InvalidWebAclIdDeserializer()
        "MissingBody" -> MissingBodyDeserializer()
        "NoSuchCachePolicy" -> NoSuchCachePolicyDeserializer()
        "NoSuchFieldLevelEncryptionConfig" -> NoSuchFieldLevelEncryptionConfigDeserializer()
        "NoSuchOrigin" -> NoSuchOriginDeserializer()
        "NoSuchOriginRequestPolicy" -> NoSuchOriginRequestPolicyDeserializer()
        "NoSuchRealtimeLogConfig" -> NoSuchRealtimeLogConfigDeserializer()
        "RealtimeLogConfigOwnerMismatch" -> RealtimeLogConfigOwnerMismatchDeserializer()
        "TooManyCacheBehaviors" -> TooManyCacheBehaviorsDeserializer()
        "TooManyCertificates" -> TooManyCertificatesDeserializer()
        "TooManyCookieNamesInWhiteList" -> TooManyCookieNamesInWhiteListDeserializer()
        "TooManyDistributionCNAMEs" -> TooManyDistributionCnamEsDeserializer()
        "TooManyDistributions" -> TooManyDistributionsDeserializer()
        "TooManyDistributionsAssociatedToCachePolicy" -> TooManyDistributionsAssociatedToCachePolicyDeserializer()
        "TooManyDistributionsAssociatedToFieldLevelEncryptionConfig" -> TooManyDistributionsAssociatedToFieldLevelEncryptionConfigDeserializer()
        "TooManyDistributionsAssociatedToKeyGroup" -> TooManyDistributionsAssociatedToKeyGroupDeserializer()
        "TooManyDistributionsAssociatedToOriginRequestPolicy" -> TooManyDistributionsAssociatedToOriginRequestPolicyDeserializer()
        "TooManyDistributionsWithFunctionAssociations" -> TooManyDistributionsWithFunctionAssociationsDeserializer()
        "TooManyDistributionsWithLambdaAssociations" -> TooManyDistributionsWithLambdaAssociationsDeserializer()
        "TooManyDistributionsWithSingleFunctionARN" -> TooManyDistributionsWithSingleFunctionArnDeserializer()
        "TooManyFunctionAssociations" -> TooManyFunctionAssociationsDeserializer()
        "TooManyHeadersInForwardedValues" -> TooManyHeadersInForwardedValuesDeserializer()
        "TooManyKeyGroupsAssociatedToDistribution" -> TooManyKeyGroupsAssociatedToDistributionDeserializer()
        "TooManyLambdaFunctionAssociations" -> TooManyLambdaFunctionAssociationsDeserializer()
        "TooManyOriginCustomHeaders" -> TooManyOriginCustomHeadersDeserializer()
        "TooManyOriginGroupsPerDistribution" -> TooManyOriginGroupsPerDistributionDeserializer()
        "TooManyOrigins" -> TooManyOriginsDeserializer()
        "TooManyQueryStringParameters" -> TooManyQueryStringParametersDeserializer()
        "TooManyTrustedSigners" -> TooManyTrustedSignersDeserializer()
        "TrustedKeyGroupDoesNotExist" -> TrustedKeyGroupDoesNotExistDeserializer()
        "TrustedSignerDoesNotExist" -> TrustedSignerDoesNotExistDeserializer()
        else -> throw CloudFrontException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
