// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.transform

import aws.sdk.kotlin.services.cloudfront.model.CreateDistributionRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName
import aws.smithy.kotlin.runtime.serde.xml.XmlSerializer


internal class CreateDistributionOperationSerializer: HttpSerialize<CreateDistributionRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateDistributionRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/2020-05-31/distribution"
        }

        if (input.distributionConfig != null) {
            val payload = serializeCreateDistributionOperationBody(context, input)
            builder.body = ByteArrayContent(payload)
        }
        builder.headers.setMissing("Content-Type", "application/xml")
        return builder
    }
}

private fun serializeCreateDistributionOperationBody(context: ExecutionContext, input: CreateDistributionRequest): ByteArray {
    val serializer = XmlSerializer()
    val input = requireNotNull(input.distributionConfig)
    val ALIASES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("Aliases"))
    val CACHEBEHAVIORS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("CacheBehaviors"))
    val CALLERREFERENCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("CallerReference"))
    val COMMENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("Comment"))
    val CUSTOMERRORRESPONSES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("CustomErrorResponses"))
    val DEFAULTCACHEBEHAVIOR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("DefaultCacheBehavior"))
    val DEFAULTROOTOBJECT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("DefaultRootObject"))
    val ENABLED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, XmlSerialName("Enabled"))
    val HTTPVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("HttpVersion"))
    val ISIPV6ENABLED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, XmlSerialName("IsIPV6Enabled"))
    val LOGGING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("Logging"))
    val ORIGINGROUPS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("OriginGroups"))
    val ORIGINS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("Origins"))
    val PRICECLASS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("PriceClass"))
    val RESTRICTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("Restrictions"))
    val VIEWERCERTIFICATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("ViewerCertificate"))
    val WEBACLID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("WebACLId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlSerialName("DistributionConfig"))
        trait(XmlNamespace("http://cloudfront.amazonaws.com/doc/2020-05-31/"))
        field(ALIASES_DESCRIPTOR)
        field(CACHEBEHAVIORS_DESCRIPTOR)
        field(CALLERREFERENCE_DESCRIPTOR)
        field(COMMENT_DESCRIPTOR)
        field(CUSTOMERRORRESPONSES_DESCRIPTOR)
        field(DEFAULTCACHEBEHAVIOR_DESCRIPTOR)
        field(DEFAULTROOTOBJECT_DESCRIPTOR)
        field(ENABLED_DESCRIPTOR)
        field(HTTPVERSION_DESCRIPTOR)
        field(ISIPV6ENABLED_DESCRIPTOR)
        field(LOGGING_DESCRIPTOR)
        field(ORIGINGROUPS_DESCRIPTOR)
        field(ORIGINS_DESCRIPTOR)
        field(PRICECLASS_DESCRIPTOR)
        field(RESTRICTIONS_DESCRIPTOR)
        field(VIEWERCERTIFICATE_DESCRIPTOR)
        field(WEBACLID_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.aliases?.let { field(ALIASES_DESCRIPTOR, it, ::serializeAliasesDocument) }
        input.cacheBehaviors?.let { field(CACHEBEHAVIORS_DESCRIPTOR, it, ::serializeCacheBehaviorsDocument) }
        input.callerReference?.let { field(CALLERREFERENCE_DESCRIPTOR, it) }
        input.comment?.let { field(COMMENT_DESCRIPTOR, it) }
        input.customErrorResponses?.let { field(CUSTOMERRORRESPONSES_DESCRIPTOR, it, ::serializeCustomErrorResponsesDocument) }
        input.defaultCacheBehavior?.let { field(DEFAULTCACHEBEHAVIOR_DESCRIPTOR, it, ::serializeDefaultCacheBehaviorDocument) }
        input.defaultRootObject?.let { field(DEFAULTROOTOBJECT_DESCRIPTOR, it) }
        input.enabled?.let { field(ENABLED_DESCRIPTOR, it) }
        input.httpVersion?.let { field(HTTPVERSION_DESCRIPTOR, it.value) }
        input.isIpv6Enabled?.let { field(ISIPV6ENABLED_DESCRIPTOR, it) }
        input.logging?.let { field(LOGGING_DESCRIPTOR, it, ::serializeLoggingConfigDocument) }
        input.originGroups?.let { field(ORIGINGROUPS_DESCRIPTOR, it, ::serializeOriginGroupsDocument) }
        input.origins?.let { field(ORIGINS_DESCRIPTOR, it, ::serializeOriginsDocument) }
        input.priceClass?.let { field(PRICECLASS_DESCRIPTOR, it.value) }
        input.restrictions?.let { field(RESTRICTIONS_DESCRIPTOR, it, ::serializeRestrictionsDocument) }
        input.viewerCertificate?.let { field(VIEWERCERTIFICATE_DESCRIPTOR, it, ::serializeViewerCertificateDocument) }
        input.webAclId?.let { field(WEBACLID_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
