// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.cloudfront.model.AssociateAliasResponse
import aws.sdk.kotlin.services.cloudfront.model.CloudFrontException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse


internal class AssociateAliasOperationDeserializer: HttpDeserialize<AssociateAliasResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): AssociateAliasResponse {
        if (!response.status.isSuccess()) {
            throwAssociateAliasError(context, response)
        }
        val builder = AssociateAliasResponse.builder()

        return builder.build()
    }
}

private suspend fun throwAssociateAliasError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as restXml error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "AccessDenied" -> AccessDeniedDeserializer()
        "IllegalUpdate" -> IllegalUpdateDeserializer()
        "InvalidArgument" -> InvalidArgumentDeserializer()
        "NoSuchDistribution" -> NoSuchDistributionDeserializer()
        "TooManyDistributionCNAMEs" -> TooManyDistributionCnamEsDeserializer()
        else -> throw CloudFrontException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
