// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model



class UpdateFunctionRequest private constructor(builder: BuilderImpl) {
    /**
     * The function code. For more information about writing a CloudFront function, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/writing-function-code.html">Writing function
     * code for CloudFront Functions in the Amazon CloudFront Developer Guide.
     */
    val functionCode: ByteArray? = builder.functionCode
    /**
     * Configuration information about the function.
     */
    val functionConfig: FunctionConfig? = builder.functionConfig
    /**
     * The current version (ETag value) of the function that you are updating, which
     * you can get using DescribeFunction.
     */
    val ifMatch: String? = builder.ifMatch
    /**
     * The name of the function that you are updating.
     */
    val name: String? = builder.name

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): UpdateFunctionRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateFunctionRequest(")
        append("functionCode=*** Sensitive Data Redacted ***,")
        append("functionConfig=$functionConfig,")
        append("ifMatch=$ifMatch,")
        append("name=$name)")
    }

    override fun hashCode(): kotlin.Int {
        var result = functionCode?.contentHashCode() ?: 0
        result = 31 * result + (functionConfig?.hashCode() ?: 0)
        result = 31 * result + (ifMatch?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as UpdateFunctionRequest

        if (functionCode != null) {
            if (other.functionCode == null) return false
            if (!functionCode.contentEquals(other.functionCode)) return false
        } else if (other.functionCode != null) return false
        if (functionConfig != other.functionConfig) return false
        if (ifMatch != other.ifMatch) return false
        if (name != other.name) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): UpdateFunctionRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): UpdateFunctionRequest
        /**
         * The function code. For more information about writing a CloudFront function, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/writing-function-code.html">Writing function
         * code for CloudFront Functions in the Amazon CloudFront Developer Guide.
         */
        fun functionCode(functionCode: ByteArray): FluentBuilder
        /**
         * Configuration information about the function.
         */
        fun functionConfig(functionConfig: FunctionConfig): FluentBuilder
        /**
         * The current version (ETag value) of the function that you are updating, which
         * you can get using DescribeFunction.
         */
        fun ifMatch(ifMatch: String): FluentBuilder
        /**
         * The name of the function that you are updating.
         */
        fun name(name: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The function code. For more information about writing a CloudFront function, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/writing-function-code.html">Writing function
         * code for CloudFront Functions in the Amazon CloudFront Developer Guide.
         */
        var functionCode: ByteArray?
        /**
         * Configuration information about the function.
         */
        var functionConfig: FunctionConfig?
        /**
         * The current version (ETag value) of the function that you are updating, which
         * you can get using DescribeFunction.
         */
        var ifMatch: String?
        /**
         * The name of the function that you are updating.
         */
        var name: String?

        fun build(): UpdateFunctionRequest
        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.FunctionConfig] inside the given [block]
         */
        fun functionConfig(block: FunctionConfig.DslBuilder.() -> kotlin.Unit) {
            this.functionConfig = FunctionConfig.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var functionCode: ByteArray? = null
        override var functionConfig: FunctionConfig? = null
        override var ifMatch: String? = null
        override var name: String? = null

        constructor(x: UpdateFunctionRequest) : this() {
            this.functionCode = x.functionCode
            this.functionConfig = x.functionConfig
            this.ifMatch = x.ifMatch
            this.name = x.name
        }

        override fun build(): UpdateFunctionRequest = UpdateFunctionRequest(this)
        override fun functionCode(functionCode: ByteArray): FluentBuilder = apply { this.functionCode = functionCode }
        override fun functionConfig(functionConfig: FunctionConfig): FluentBuilder = apply { this.functionConfig = functionConfig }
        override fun ifMatch(ifMatch: String): FluentBuilder = apply { this.ifMatch = ifMatch }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
    }
}
