// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model



/**
 * Contains the result of testing a CloudFront function with TestFunction.
 */
class TestResult private constructor(builder: BuilderImpl) {
    /**
     * The amount of time that the function took to run as a percentage of the maximum
     * allowed time. For example, a compute utilization of 35 means that the function completed
     * in 35% of the maximum allowed time.
     */
    val computeUtilization: String? = builder.computeUtilization
    /**
     * If the result of testing the function was an error, this field contains the error
     * message.
     */
    val functionErrorMessage: String? = builder.functionErrorMessage
    /**
     * Contains the log lines that the function wrote (if any) when running the test.
     */
    val functionExecutionLogs: List<String>? = builder.functionExecutionLogs
    /**
     * The event object returned by the function. For more information about the structure of the
     * event object, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/functions-event-structure.html">Event object
     * structure in the Amazon CloudFront Developer Guide.
     */
    val functionOutput: String? = builder.functionOutput
    /**
     * Contains configuration information and metadata about the CloudFront function that was
     * tested.
     */
    val functionSummary: FunctionSummary? = builder.functionSummary

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): TestResult = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("TestResult(")
        append("computeUtilization=$computeUtilization,")
        append("functionErrorMessage=$functionErrorMessage,")
        append("functionExecutionLogs=$functionExecutionLogs,")
        append("functionOutput=$functionOutput,")
        append("functionSummary=$functionSummary)")
    }

    override fun hashCode(): kotlin.Int {
        var result = computeUtilization?.hashCode() ?: 0
        result = 31 * result + (functionErrorMessage?.hashCode() ?: 0)
        result = 31 * result + (functionExecutionLogs?.hashCode() ?: 0)
        result = 31 * result + (functionOutput?.hashCode() ?: 0)
        result = 31 * result + (functionSummary?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as TestResult

        if (computeUtilization != other.computeUtilization) return false
        if (functionErrorMessage != other.functionErrorMessage) return false
        if (functionExecutionLogs != other.functionExecutionLogs) return false
        if (functionOutput != other.functionOutput) return false
        if (functionSummary != other.functionSummary) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): TestResult = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): TestResult
        /**
         * The amount of time that the function took to run as a percentage of the maximum
         * allowed time. For example, a compute utilization of 35 means that the function completed
         * in 35% of the maximum allowed time.
         */
        fun computeUtilization(computeUtilization: String): FluentBuilder
        /**
         * If the result of testing the function was an error, this field contains the error
         * message.
         */
        fun functionErrorMessage(functionErrorMessage: String): FluentBuilder
        /**
         * Contains the log lines that the function wrote (if any) when running the test.
         */
        fun functionExecutionLogs(functionExecutionLogs: List<String>): FluentBuilder
        /**
         * The event object returned by the function. For more information about the structure of the
         * event object, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/functions-event-structure.html">Event object
         * structure in the Amazon CloudFront Developer Guide.
         */
        fun functionOutput(functionOutput: String): FluentBuilder
        /**
         * Contains configuration information and metadata about the CloudFront function that was
         * tested.
         */
        fun functionSummary(functionSummary: FunctionSummary): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The amount of time that the function took to run as a percentage of the maximum
         * allowed time. For example, a compute utilization of 35 means that the function completed
         * in 35% of the maximum allowed time.
         */
        var computeUtilization: String?
        /**
         * If the result of testing the function was an error, this field contains the error
         * message.
         */
        var functionErrorMessage: String?
        /**
         * Contains the log lines that the function wrote (if any) when running the test.
         */
        var functionExecutionLogs: List<String>?
        /**
         * The event object returned by the function. For more information about the structure of the
         * event object, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/functions-event-structure.html">Event object
         * structure in the Amazon CloudFront Developer Guide.
         */
        var functionOutput: String?
        /**
         * Contains configuration information and metadata about the CloudFront function that was
         * tested.
         */
        var functionSummary: FunctionSummary?

        fun build(): TestResult
        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.FunctionSummary] inside the given [block]
         */
        fun functionSummary(block: FunctionSummary.DslBuilder.() -> kotlin.Unit) {
            this.functionSummary = FunctionSummary.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var computeUtilization: String? = null
        override var functionErrorMessage: String? = null
        override var functionExecutionLogs: List<String>? = null
        override var functionOutput: String? = null
        override var functionSummary: FunctionSummary? = null

        constructor(x: TestResult) : this() {
            this.computeUtilization = x.computeUtilization
            this.functionErrorMessage = x.functionErrorMessage
            this.functionExecutionLogs = x.functionExecutionLogs
            this.functionOutput = x.functionOutput
            this.functionSummary = x.functionSummary
        }

        override fun build(): TestResult = TestResult(this)
        override fun computeUtilization(computeUtilization: String): FluentBuilder = apply { this.computeUtilization = computeUtilization }
        override fun functionErrorMessage(functionErrorMessage: String): FluentBuilder = apply { this.functionErrorMessage = functionErrorMessage }
        override fun functionExecutionLogs(functionExecutionLogs: List<String>): FluentBuilder = apply { this.functionExecutionLogs = functionExecutionLogs }
        override fun functionOutput(functionOutput: String): FluentBuilder = apply { this.functionOutput = functionOutput }
        override fun functionSummary(functionSummary: FunctionSummary): FluentBuilder = apply { this.functionSummary = functionSummary }
    }
}
