// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model



class TestFunctionRequest private constructor(builder: BuilderImpl) {
    /**
     * The event object to test the function with. For more information about the structure of the
     * event object, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/managing-functions.html#test-function">Testing functions in the Amazon CloudFront Developer Guide.
     */
    val eventObject: ByteArray? = builder.eventObject
    /**
     * The current version (ETag value) of the function that you are testing, which
     * you can get using DescribeFunction.
     */
    val ifMatch: String? = builder.ifMatch
    /**
     * The name of the function that you are testing.
     */
    val name: String? = builder.name
    /**
     * The stage of the function that you are testing, either DEVELOPMENT or
     * LIVE.
     */
    val stage: FunctionStage? = builder.stage

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): TestFunctionRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("TestFunctionRequest(")
        append("eventObject=*** Sensitive Data Redacted ***,")
        append("ifMatch=$ifMatch,")
        append("name=$name,")
        append("stage=$stage)")
    }

    override fun hashCode(): kotlin.Int {
        var result = eventObject?.contentHashCode() ?: 0
        result = 31 * result + (ifMatch?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (stage?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as TestFunctionRequest

        if (eventObject != null) {
            if (other.eventObject == null) return false
            if (!eventObject.contentEquals(other.eventObject)) return false
        } else if (other.eventObject != null) return false
        if (ifMatch != other.ifMatch) return false
        if (name != other.name) return false
        if (stage != other.stage) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): TestFunctionRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): TestFunctionRequest
        /**
         * The event object to test the function with. For more information about the structure of the
         * event object, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/managing-functions.html#test-function">Testing functions in the Amazon CloudFront Developer Guide.
         */
        fun eventObject(eventObject: ByteArray): FluentBuilder
        /**
         * The current version (ETag value) of the function that you are testing, which
         * you can get using DescribeFunction.
         */
        fun ifMatch(ifMatch: String): FluentBuilder
        /**
         * The name of the function that you are testing.
         */
        fun name(name: String): FluentBuilder
        /**
         * The stage of the function that you are testing, either DEVELOPMENT or
         * LIVE.
         */
        fun stage(stage: FunctionStage): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The event object to test the function with. For more information about the structure of the
         * event object, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/managing-functions.html#test-function">Testing functions in the Amazon CloudFront Developer Guide.
         */
        var eventObject: ByteArray?
        /**
         * The current version (ETag value) of the function that you are testing, which
         * you can get using DescribeFunction.
         */
        var ifMatch: String?
        /**
         * The name of the function that you are testing.
         */
        var name: String?
        /**
         * The stage of the function that you are testing, either DEVELOPMENT or
         * LIVE.
         */
        var stage: FunctionStage?

        fun build(): TestFunctionRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var eventObject: ByteArray? = null
        override var ifMatch: String? = null
        override var name: String? = null
        override var stage: FunctionStage? = null

        constructor(x: TestFunctionRequest) : this() {
            this.eventObject = x.eventObject
            this.ifMatch = x.ifMatch
            this.name = x.name
            this.stage = x.stage
        }

        override fun build(): TestFunctionRequest = TestFunctionRequest(this)
        override fun eventObject(eventObject: ByteArray): FluentBuilder = apply { this.eventObject = eventObject }
        override fun ifMatch(ifMatch: String): FluentBuilder = apply { this.ifMatch = ifMatch }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun stage(stage: FunctionStage): FluentBuilder = apply { this.stage = stage }
    }
}
