// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model



/**
 * A complex type that controls whether access logs are written for this streaming distribution.
 */
class StreamingLoggingConfig private constructor(builder: BuilderImpl) {
    /**
     * The Amazon S3 bucket to store the access logs in, for example, myawslogbucket.s3.amazonaws.com.
     */
    val bucket: String? = builder.bucket
    /**
     * Specifies whether you want CloudFront to save access logs to an Amazon S3 bucket. If you don't
     * want to enable logging when you create a streaming distribution or if you want to disable
     * logging for an existing streaming distribution, specify false for
     * Enabled, and specify empty Bucket and Prefix
     * elements. If you specify false for Enabled but you specify values
     * for Bucket and Prefix, the values are automatically deleted.
     */
    val enabled: Boolean? = builder.enabled
    /**
     * An optional string that you want CloudFront to prefix to the access log filenames for this streaming distribution, for example,
     * myprefix/. If you want to enable logging, but you don't want to specify a prefix, you still must include
     * an empty Prefix element in the Logging element.
     */
    val prefix: String? = builder.prefix

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): StreamingLoggingConfig = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("StreamingLoggingConfig(")
        append("bucket=$bucket,")
        append("enabled=$enabled,")
        append("prefix=$prefix)")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucket?.hashCode() ?: 0
        result = 31 * result + (enabled?.hashCode() ?: 0)
        result = 31 * result + (prefix?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as StreamingLoggingConfig

        if (bucket != other.bucket) return false
        if (enabled != other.enabled) return false
        if (prefix != other.prefix) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): StreamingLoggingConfig = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): StreamingLoggingConfig
        /**
         * The Amazon S3 bucket to store the access logs in, for example, myawslogbucket.s3.amazonaws.com.
         */
        fun bucket(bucket: String): FluentBuilder
        /**
         * Specifies whether you want CloudFront to save access logs to an Amazon S3 bucket. If you don't
         * want to enable logging when you create a streaming distribution or if you want to disable
         * logging for an existing streaming distribution, specify false for
         * Enabled, and specify empty Bucket and Prefix
         * elements. If you specify false for Enabled but you specify values
         * for Bucket and Prefix, the values are automatically deleted.
         */
        fun enabled(enabled: Boolean): FluentBuilder
        /**
         * An optional string that you want CloudFront to prefix to the access log filenames for this streaming distribution, for example,
         * myprefix/. If you want to enable logging, but you don't want to specify a prefix, you still must include
         * an empty Prefix element in the Logging element.
         */
        fun prefix(prefix: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon S3 bucket to store the access logs in, for example, myawslogbucket.s3.amazonaws.com.
         */
        var bucket: String?
        /**
         * Specifies whether you want CloudFront to save access logs to an Amazon S3 bucket. If you don't
         * want to enable logging when you create a streaming distribution or if you want to disable
         * logging for an existing streaming distribution, specify false for
         * Enabled, and specify empty Bucket and Prefix
         * elements. If you specify false for Enabled but you specify values
         * for Bucket and Prefix, the values are automatically deleted.
         */
        var enabled: Boolean?
        /**
         * An optional string that you want CloudFront to prefix to the access log filenames for this streaming distribution, for example,
         * myprefix/. If you want to enable logging, but you don't want to specify a prefix, you still must include
         * an empty Prefix element in the Logging element.
         */
        var prefix: String?

        fun build(): StreamingLoggingConfig
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var bucket: String? = null
        override var enabled: Boolean? = null
        override var prefix: String? = null

        constructor(x: StreamingLoggingConfig) : this() {
            this.bucket = x.bucket
            this.enabled = x.enabled
            this.prefix = x.prefix
        }

        override fun build(): StreamingLoggingConfig = StreamingLoggingConfig(this)
        override fun bucket(bucket: String): FluentBuilder = apply { this.bucket = bucket }
        override fun enabled(enabled: Boolean): FluentBuilder = apply { this.enabled = enabled }
        override fun prefix(prefix: String): FluentBuilder = apply { this.prefix = prefix }
    }
}
