// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A summary of the information for a CloudFront streaming distribution.
 */
class StreamingDistributionSummary private constructor(builder: BuilderImpl) {
    /**
     * A complex type that contains information about CNAMEs (alternate domain names), if any,
     * for this streaming distribution.
     */
    val aliases: Aliases? = builder.aliases
    /**
     * The ARN (Amazon Resource Name) for the streaming distribution. For example:
     * arn:aws:cloudfront::123456789012:streaming-distribution/EDFDVBD632BHDS5, where
     * 123456789012 is your account ID.
     */
    val arn: String? = builder.arn
    /**
     * The comment originally specified when this distribution was created.
     */
    val comment: String? = builder.comment
    /**
     * The domain name corresponding to the distribution, for example, d111111abcdef8.cloudfront.net.
     */
    val domainName: String? = builder.domainName
    /**
     * Whether the distribution is enabled to accept end user requests for content.
     */
    val enabled: Boolean? = builder.enabled
    /**
     * The identifier for the distribution, for example, EDFDVBD632BHDS5.
     */
    val id: String? = builder.id
    /**
     * The date and time the distribution was last modified.
     */
    val lastModifiedTime: Instant? = builder.lastModifiedTime
    /**
     * A complex type that contains information about price class for this streaming
     * distribution.
     */
    val priceClass: PriceClass? = builder.priceClass
    /**
     * A complex type that contains information about the Amazon S3 bucket from which you want
     * CloudFront to get your media files for distribution.
     */
    val s3Origin: S3Origin? = builder.s3Origin
    /**
     * Indicates the current status of the distribution. When the status is
     * Deployed, the distribution's information is fully propagated throughout the
     * Amazon CloudFront system.
     */
    val status: String? = builder.status
    /**
     * A complex type that specifies the accounts, if any, that you want to allow to
     * create signed URLs for private content. If you want to require signed URLs in requests for
     * objects in the target origin that match the PathPattern for this cache behavior,
     * specify true for Enabled, and specify the applicable values for
     * Quantity and Items.If you don't want to require signed URLs in
     * requests for objects that match PathPattern, specify false for
     * Enabled and 0 for Quantity. Omit Items.
     * To add, change, or remove one or more trusted signers, change Enabled to
     * true (if it's currently false), change Quantity as
     * applicable, and specify all of the trusted signers that you want to include in the updated
     * distribution.
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving Private
     * Content through CloudFront in the Amazon CloudFront Developer Guide.
     */
    val trustedSigners: TrustedSigners? = builder.trustedSigners

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): StreamingDistributionSummary = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("StreamingDistributionSummary(")
        append("aliases=$aliases,")
        append("arn=$arn,")
        append("comment=$comment,")
        append("domainName=$domainName,")
        append("enabled=$enabled,")
        append("id=$id,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("priceClass=$priceClass,")
        append("s3Origin=$s3Origin,")
        append("status=$status,")
        append("trustedSigners=$trustedSigners)")
    }

    override fun hashCode(): kotlin.Int {
        var result = aliases?.hashCode() ?: 0
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (comment?.hashCode() ?: 0)
        result = 31 * result + (domainName?.hashCode() ?: 0)
        result = 31 * result + (enabled?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (priceClass?.hashCode() ?: 0)
        result = 31 * result + (s3Origin?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (trustedSigners?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as StreamingDistributionSummary

        if (aliases != other.aliases) return false
        if (arn != other.arn) return false
        if (comment != other.comment) return false
        if (domainName != other.domainName) return false
        if (enabled != other.enabled) return false
        if (id != other.id) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (priceClass != other.priceClass) return false
        if (s3Origin != other.s3Origin) return false
        if (status != other.status) return false
        if (trustedSigners != other.trustedSigners) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): StreamingDistributionSummary = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): StreamingDistributionSummary
        /**
         * A complex type that contains information about CNAMEs (alternate domain names), if any,
         * for this streaming distribution.
         */
        fun aliases(aliases: Aliases): FluentBuilder
        /**
         * The ARN (Amazon Resource Name) for the streaming distribution. For example:
         * arn:aws:cloudfront::123456789012:streaming-distribution/EDFDVBD632BHDS5, where
         * 123456789012 is your account ID.
         */
        fun arn(arn: String): FluentBuilder
        /**
         * The comment originally specified when this distribution was created.
         */
        fun comment(comment: String): FluentBuilder
        /**
         * The domain name corresponding to the distribution, for example, d111111abcdef8.cloudfront.net.
         */
        fun domainName(domainName: String): FluentBuilder
        /**
         * Whether the distribution is enabled to accept end user requests for content.
         */
        fun enabled(enabled: Boolean): FluentBuilder
        /**
         * The identifier for the distribution, for example, EDFDVBD632BHDS5.
         */
        fun id(id: String): FluentBuilder
        /**
         * The date and time the distribution was last modified.
         */
        fun lastModifiedTime(lastModifiedTime: Instant): FluentBuilder
        /**
         * A complex type that contains information about price class for this streaming
         * distribution.
         */
        fun priceClass(priceClass: PriceClass): FluentBuilder
        /**
         * A complex type that contains information about the Amazon S3 bucket from which you want
         * CloudFront to get your media files for distribution.
         */
        fun s3Origin(s3Origin: S3Origin): FluentBuilder
        /**
         * Indicates the current status of the distribution. When the status is
         * Deployed, the distribution's information is fully propagated throughout the
         * Amazon CloudFront system.
         */
        fun status(status: String): FluentBuilder
        /**
         * A complex type that specifies the accounts, if any, that you want to allow to
         * create signed URLs for private content. If you want to require signed URLs in requests for
         * objects in the target origin that match the PathPattern for this cache behavior,
         * specify true for Enabled, and specify the applicable values for
         * Quantity and Items.If you don't want to require signed URLs in
         * requests for objects that match PathPattern, specify false for
         * Enabled and 0 for Quantity. Omit Items.
         * To add, change, or remove one or more trusted signers, change Enabled to
         * true (if it's currently false), change Quantity as
         * applicable, and specify all of the trusted signers that you want to include in the updated
         * distribution.
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving Private
         * Content through CloudFront in the Amazon CloudFront Developer Guide.
         */
        fun trustedSigners(trustedSigners: TrustedSigners): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A complex type that contains information about CNAMEs (alternate domain names), if any,
         * for this streaming distribution.
         */
        var aliases: Aliases?
        /**
         * The ARN (Amazon Resource Name) for the streaming distribution. For example:
         * arn:aws:cloudfront::123456789012:streaming-distribution/EDFDVBD632BHDS5, where
         * 123456789012 is your account ID.
         */
        var arn: String?
        /**
         * The comment originally specified when this distribution was created.
         */
        var comment: String?
        /**
         * The domain name corresponding to the distribution, for example, d111111abcdef8.cloudfront.net.
         */
        var domainName: String?
        /**
         * Whether the distribution is enabled to accept end user requests for content.
         */
        var enabled: Boolean?
        /**
         * The identifier for the distribution, for example, EDFDVBD632BHDS5.
         */
        var id: String?
        /**
         * The date and time the distribution was last modified.
         */
        var lastModifiedTime: Instant?
        /**
         * A complex type that contains information about price class for this streaming
         * distribution.
         */
        var priceClass: PriceClass?
        /**
         * A complex type that contains information about the Amazon S3 bucket from which you want
         * CloudFront to get your media files for distribution.
         */
        var s3Origin: S3Origin?
        /**
         * Indicates the current status of the distribution. When the status is
         * Deployed, the distribution's information is fully propagated throughout the
         * Amazon CloudFront system.
         */
        var status: String?
        /**
         * A complex type that specifies the accounts, if any, that you want to allow to
         * create signed URLs for private content. If you want to require signed URLs in requests for
         * objects in the target origin that match the PathPattern for this cache behavior,
         * specify true for Enabled, and specify the applicable values for
         * Quantity and Items.If you don't want to require signed URLs in
         * requests for objects that match PathPattern, specify false for
         * Enabled and 0 for Quantity. Omit Items.
         * To add, change, or remove one or more trusted signers, change Enabled to
         * true (if it's currently false), change Quantity as
         * applicable, and specify all of the trusted signers that you want to include in the updated
         * distribution.
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving Private
         * Content through CloudFront in the Amazon CloudFront Developer Guide.
         */
        var trustedSigners: TrustedSigners?

        fun build(): StreamingDistributionSummary
        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.Aliases] inside the given [block]
         */
        fun aliases(block: Aliases.DslBuilder.() -> kotlin.Unit) {
            this.aliases = Aliases.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.S3Origin] inside the given [block]
         */
        fun s3Origin(block: S3Origin.DslBuilder.() -> kotlin.Unit) {
            this.s3Origin = S3Origin.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.TrustedSigners] inside the given [block]
         */
        fun trustedSigners(block: TrustedSigners.DslBuilder.() -> kotlin.Unit) {
            this.trustedSigners = TrustedSigners.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var aliases: Aliases? = null
        override var arn: String? = null
        override var comment: String? = null
        override var domainName: String? = null
        override var enabled: Boolean? = null
        override var id: String? = null
        override var lastModifiedTime: Instant? = null
        override var priceClass: PriceClass? = null
        override var s3Origin: S3Origin? = null
        override var status: String? = null
        override var trustedSigners: TrustedSigners? = null

        constructor(x: StreamingDistributionSummary) : this() {
            this.aliases = x.aliases
            this.arn = x.arn
            this.comment = x.comment
            this.domainName = x.domainName
            this.enabled = x.enabled
            this.id = x.id
            this.lastModifiedTime = x.lastModifiedTime
            this.priceClass = x.priceClass
            this.s3Origin = x.s3Origin
            this.status = x.status
            this.trustedSigners = x.trustedSigners
        }

        override fun build(): StreamingDistributionSummary = StreamingDistributionSummary(this)
        override fun aliases(aliases: Aliases): FluentBuilder = apply { this.aliases = aliases }
        override fun arn(arn: String): FluentBuilder = apply { this.arn = arn }
        override fun comment(comment: String): FluentBuilder = apply { this.comment = comment }
        override fun domainName(domainName: String): FluentBuilder = apply { this.domainName = domainName }
        override fun enabled(enabled: Boolean): FluentBuilder = apply { this.enabled = enabled }
        override fun id(id: String): FluentBuilder = apply { this.id = id }
        override fun lastModifiedTime(lastModifiedTime: Instant): FluentBuilder = apply { this.lastModifiedTime = lastModifiedTime }
        override fun priceClass(priceClass: PriceClass): FluentBuilder = apply { this.priceClass = priceClass }
        override fun s3Origin(s3Origin: S3Origin): FluentBuilder = apply { this.s3Origin = s3Origin }
        override fun status(status: String): FluentBuilder = apply { this.status = status }
        override fun trustedSigners(trustedSigners: TrustedSigners): FluentBuilder = apply { this.trustedSigners = trustedSigners }
    }
}
