// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model



/**
 * The RTMP distribution's configuration information.
 */
class StreamingDistributionConfig private constructor(builder: BuilderImpl) {
    /**
     * A complex type that contains information about CNAMEs (alternate domain names), if any,
     * for this streaming distribution.
     */
    val aliases: Aliases? = builder.aliases
    /**
     * A unique value (for example, a date-time stamp) that ensures that the request can't be
     * replayed.
     * If the value of CallerReference is new (regardless of the content of the
     * StreamingDistributionConfig object), CloudFront creates a new distribution.
     * If CallerReference is a value that you already sent in a previous request to
     * create a distribution, CloudFront returns a DistributionAlreadyExists error.
     */
    val callerReference: String? = builder.callerReference
    /**
     * Any comments you want to include about the streaming distribution.
     */
    val comment: String? = builder.comment
    /**
     * Whether the streaming distribution is enabled to accept user requests for
     * content.
     */
    val enabled: Boolean? = builder.enabled
    /**
     * A complex type that controls whether access logs are written for the streaming
     * distribution.
     */
    val logging: StreamingLoggingConfig? = builder.logging
    /**
     * A complex type that contains information about price class for this streaming
     * distribution.
     */
    val priceClass: PriceClass? = builder.priceClass
    /**
     * A complex type that contains information about the Amazon S3 bucket from which you want
     * CloudFront to get your media files for distribution.
     */
    val s3Origin: S3Origin? = builder.s3Origin
    /**
     * A complex type that specifies any accounts that you want to permit to create signed
     * URLs for private content. If you want the distribution to use signed URLs, include this
     * element; if you want the distribution to use public URLs, remove this element. For more
     * information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving Private Content through
     * CloudFront in the Amazon CloudFront Developer Guide.
     */
    val trustedSigners: TrustedSigners? = builder.trustedSigners

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): StreamingDistributionConfig = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("StreamingDistributionConfig(")
        append("aliases=$aliases,")
        append("callerReference=$callerReference,")
        append("comment=$comment,")
        append("enabled=$enabled,")
        append("logging=$logging,")
        append("priceClass=$priceClass,")
        append("s3Origin=$s3Origin,")
        append("trustedSigners=$trustedSigners)")
    }

    override fun hashCode(): kotlin.Int {
        var result = aliases?.hashCode() ?: 0
        result = 31 * result + (callerReference?.hashCode() ?: 0)
        result = 31 * result + (comment?.hashCode() ?: 0)
        result = 31 * result + (enabled?.hashCode() ?: 0)
        result = 31 * result + (logging?.hashCode() ?: 0)
        result = 31 * result + (priceClass?.hashCode() ?: 0)
        result = 31 * result + (s3Origin?.hashCode() ?: 0)
        result = 31 * result + (trustedSigners?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as StreamingDistributionConfig

        if (aliases != other.aliases) return false
        if (callerReference != other.callerReference) return false
        if (comment != other.comment) return false
        if (enabled != other.enabled) return false
        if (logging != other.logging) return false
        if (priceClass != other.priceClass) return false
        if (s3Origin != other.s3Origin) return false
        if (trustedSigners != other.trustedSigners) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): StreamingDistributionConfig = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): StreamingDistributionConfig
        /**
         * A complex type that contains information about CNAMEs (alternate domain names), if any,
         * for this streaming distribution.
         */
        fun aliases(aliases: Aliases): FluentBuilder
        /**
         * A unique value (for example, a date-time stamp) that ensures that the request can't be
         * replayed.
         * If the value of CallerReference is new (regardless of the content of the
         * StreamingDistributionConfig object), CloudFront creates a new distribution.
         * If CallerReference is a value that you already sent in a previous request to
         * create a distribution, CloudFront returns a DistributionAlreadyExists error.
         */
        fun callerReference(callerReference: String): FluentBuilder
        /**
         * Any comments you want to include about the streaming distribution.
         */
        fun comment(comment: String): FluentBuilder
        /**
         * Whether the streaming distribution is enabled to accept user requests for
         * content.
         */
        fun enabled(enabled: Boolean): FluentBuilder
        /**
         * A complex type that controls whether access logs are written for the streaming
         * distribution.
         */
        fun logging(logging: StreamingLoggingConfig): FluentBuilder
        /**
         * A complex type that contains information about price class for this streaming
         * distribution.
         */
        fun priceClass(priceClass: PriceClass): FluentBuilder
        /**
         * A complex type that contains information about the Amazon S3 bucket from which you want
         * CloudFront to get your media files for distribution.
         */
        fun s3Origin(s3Origin: S3Origin): FluentBuilder
        /**
         * A complex type that specifies any accounts that you want to permit to create signed
         * URLs for private content. If you want the distribution to use signed URLs, include this
         * element; if you want the distribution to use public URLs, remove this element. For more
         * information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving Private Content through
         * CloudFront in the Amazon CloudFront Developer Guide.
         */
        fun trustedSigners(trustedSigners: TrustedSigners): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A complex type that contains information about CNAMEs (alternate domain names), if any,
         * for this streaming distribution.
         */
        var aliases: Aliases?
        /**
         * A unique value (for example, a date-time stamp) that ensures that the request can't be
         * replayed.
         * If the value of CallerReference is new (regardless of the content of the
         * StreamingDistributionConfig object), CloudFront creates a new distribution.
         * If CallerReference is a value that you already sent in a previous request to
         * create a distribution, CloudFront returns a DistributionAlreadyExists error.
         */
        var callerReference: String?
        /**
         * Any comments you want to include about the streaming distribution.
         */
        var comment: String?
        /**
         * Whether the streaming distribution is enabled to accept user requests for
         * content.
         */
        var enabled: Boolean?
        /**
         * A complex type that controls whether access logs are written for the streaming
         * distribution.
         */
        var logging: StreamingLoggingConfig?
        /**
         * A complex type that contains information about price class for this streaming
         * distribution.
         */
        var priceClass: PriceClass?
        /**
         * A complex type that contains information about the Amazon S3 bucket from which you want
         * CloudFront to get your media files for distribution.
         */
        var s3Origin: S3Origin?
        /**
         * A complex type that specifies any accounts that you want to permit to create signed
         * URLs for private content. If you want the distribution to use signed URLs, include this
         * element; if you want the distribution to use public URLs, remove this element. For more
         * information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving Private Content through
         * CloudFront in the Amazon CloudFront Developer Guide.
         */
        var trustedSigners: TrustedSigners?

        fun build(): StreamingDistributionConfig
        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.Aliases] inside the given [block]
         */
        fun aliases(block: Aliases.DslBuilder.() -> kotlin.Unit) {
            this.aliases = Aliases.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.StreamingLoggingConfig] inside the given [block]
         */
        fun logging(block: StreamingLoggingConfig.DslBuilder.() -> kotlin.Unit) {
            this.logging = StreamingLoggingConfig.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.S3Origin] inside the given [block]
         */
        fun s3Origin(block: S3Origin.DslBuilder.() -> kotlin.Unit) {
            this.s3Origin = S3Origin.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.TrustedSigners] inside the given [block]
         */
        fun trustedSigners(block: TrustedSigners.DslBuilder.() -> kotlin.Unit) {
            this.trustedSigners = TrustedSigners.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var aliases: Aliases? = null
        override var callerReference: String? = null
        override var comment: String? = null
        override var enabled: Boolean? = null
        override var logging: StreamingLoggingConfig? = null
        override var priceClass: PriceClass? = null
        override var s3Origin: S3Origin? = null
        override var trustedSigners: TrustedSigners? = null

        constructor(x: StreamingDistributionConfig) : this() {
            this.aliases = x.aliases
            this.callerReference = x.callerReference
            this.comment = x.comment
            this.enabled = x.enabled
            this.logging = x.logging
            this.priceClass = x.priceClass
            this.s3Origin = x.s3Origin
            this.trustedSigners = x.trustedSigners
        }

        override fun build(): StreamingDistributionConfig = StreamingDistributionConfig(this)
        override fun aliases(aliases: Aliases): FluentBuilder = apply { this.aliases = aliases }
        override fun callerReference(callerReference: String): FluentBuilder = apply { this.callerReference = callerReference }
        override fun comment(comment: String): FluentBuilder = apply { this.comment = comment }
        override fun enabled(enabled: Boolean): FluentBuilder = apply { this.enabled = enabled }
        override fun logging(logging: StreamingLoggingConfig): FluentBuilder = apply { this.logging = logging }
        override fun priceClass(priceClass: PriceClass): FluentBuilder = apply { this.priceClass = priceClass }
        override fun s3Origin(s3Origin: S3Origin): FluentBuilder = apply { this.s3Origin = s3Origin }
        override fun trustedSigners(trustedSigners: TrustedSigners): FluentBuilder = apply { this.trustedSigners = trustedSigners }
    }
}
