// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A streaming distribution tells CloudFront where you want RTMP content to be delivered from, and the details about how to
 * track and manage content delivery.
 */
class StreamingDistribution private constructor(builder: BuilderImpl) {
    /**
     * A complex type that lists the accounts, if any, that you included in the
     * TrustedSigners complex type for this distribution. These are the accounts that
     * you want to allow to create signed URLs for private content.
     * The Signer complex type lists the account number of the trusted
     * signer or self if the signer is the account that created the distribution.
     * The Signer element also includes the IDs of any active CloudFront key pairs that are
     * associated with the trusted signer's account. If no KeyPairId element
     * appears for a Signer, that signer can't create signed URLs.
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving Private
     * Content through CloudFront in the Amazon CloudFront Developer Guide.
     */
    val activeTrustedSigners: ActiveTrustedSigners? = builder.activeTrustedSigners
    /**
     * The ARN (Amazon Resource Name) for the distribution. For example:
     * arn:aws:cloudfront::123456789012:distribution/EDFDVBD632BHDS5, where
     * 123456789012 is your account ID.
     */
    val arn: String? = builder.arn
    /**
     * The domain name that corresponds to the streaming distribution, for example, s5c39gqb8ow64r.cloudfront.net.
     */
    val domainName: String? = builder.domainName
    /**
     * The identifier for the RTMP distribution. For example:
     * EGTXBD79EXAMPLE.
     */
    val id: String? = builder.id
    /**
     * The date and time that the distribution was last modified.
     */
    val lastModifiedTime: Instant? = builder.lastModifiedTime
    /**
     * The current status of the RTMP distribution. When the status is Deployed,
     * the distribution's information is propagated to all CloudFront edge locations.
     */
    val status: String? = builder.status
    /**
     * The current configuration information for the RTMP distribution.
     */
    val streamingDistributionConfig: StreamingDistributionConfig? = builder.streamingDistributionConfig

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): StreamingDistribution = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("StreamingDistribution(")
        append("activeTrustedSigners=$activeTrustedSigners,")
        append("arn=$arn,")
        append("domainName=$domainName,")
        append("id=$id,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("status=$status,")
        append("streamingDistributionConfig=$streamingDistributionConfig)")
    }

    override fun hashCode(): kotlin.Int {
        var result = activeTrustedSigners?.hashCode() ?: 0
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (domainName?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (streamingDistributionConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as StreamingDistribution

        if (activeTrustedSigners != other.activeTrustedSigners) return false
        if (arn != other.arn) return false
        if (domainName != other.domainName) return false
        if (id != other.id) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (status != other.status) return false
        if (streamingDistributionConfig != other.streamingDistributionConfig) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): StreamingDistribution = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): StreamingDistribution
        /**
         * A complex type that lists the accounts, if any, that you included in the
         * TrustedSigners complex type for this distribution. These are the accounts that
         * you want to allow to create signed URLs for private content.
         * The Signer complex type lists the account number of the trusted
         * signer or self if the signer is the account that created the distribution.
         * The Signer element also includes the IDs of any active CloudFront key pairs that are
         * associated with the trusted signer's account. If no KeyPairId element
         * appears for a Signer, that signer can't create signed URLs.
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving Private
         * Content through CloudFront in the Amazon CloudFront Developer Guide.
         */
        fun activeTrustedSigners(activeTrustedSigners: ActiveTrustedSigners): FluentBuilder
        /**
         * The ARN (Amazon Resource Name) for the distribution. For example:
         * arn:aws:cloudfront::123456789012:distribution/EDFDVBD632BHDS5, where
         * 123456789012 is your account ID.
         */
        fun arn(arn: String): FluentBuilder
        /**
         * The domain name that corresponds to the streaming distribution, for example, s5c39gqb8ow64r.cloudfront.net.
         */
        fun domainName(domainName: String): FluentBuilder
        /**
         * The identifier for the RTMP distribution. For example:
         * EGTXBD79EXAMPLE.
         */
        fun id(id: String): FluentBuilder
        /**
         * The date and time that the distribution was last modified.
         */
        fun lastModifiedTime(lastModifiedTime: Instant): FluentBuilder
        /**
         * The current status of the RTMP distribution. When the status is Deployed,
         * the distribution's information is propagated to all CloudFront edge locations.
         */
        fun status(status: String): FluentBuilder
        /**
         * The current configuration information for the RTMP distribution.
         */
        fun streamingDistributionConfig(streamingDistributionConfig: StreamingDistributionConfig): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A complex type that lists the accounts, if any, that you included in the
         * TrustedSigners complex type for this distribution. These are the accounts that
         * you want to allow to create signed URLs for private content.
         * The Signer complex type lists the account number of the trusted
         * signer or self if the signer is the account that created the distribution.
         * The Signer element also includes the IDs of any active CloudFront key pairs that are
         * associated with the trusted signer's account. If no KeyPairId element
         * appears for a Signer, that signer can't create signed URLs.
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving Private
         * Content through CloudFront in the Amazon CloudFront Developer Guide.
         */
        var activeTrustedSigners: ActiveTrustedSigners?
        /**
         * The ARN (Amazon Resource Name) for the distribution. For example:
         * arn:aws:cloudfront::123456789012:distribution/EDFDVBD632BHDS5, where
         * 123456789012 is your account ID.
         */
        var arn: String?
        /**
         * The domain name that corresponds to the streaming distribution, for example, s5c39gqb8ow64r.cloudfront.net.
         */
        var domainName: String?
        /**
         * The identifier for the RTMP distribution. For example:
         * EGTXBD79EXAMPLE.
         */
        var id: String?
        /**
         * The date and time that the distribution was last modified.
         */
        var lastModifiedTime: Instant?
        /**
         * The current status of the RTMP distribution. When the status is Deployed,
         * the distribution's information is propagated to all CloudFront edge locations.
         */
        var status: String?
        /**
         * The current configuration information for the RTMP distribution.
         */
        var streamingDistributionConfig: StreamingDistributionConfig?

        fun build(): StreamingDistribution
        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.ActiveTrustedSigners] inside the given [block]
         */
        fun activeTrustedSigners(block: ActiveTrustedSigners.DslBuilder.() -> kotlin.Unit) {
            this.activeTrustedSigners = ActiveTrustedSigners.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.StreamingDistributionConfig] inside the given [block]
         */
        fun streamingDistributionConfig(block: StreamingDistributionConfig.DslBuilder.() -> kotlin.Unit) {
            this.streamingDistributionConfig = StreamingDistributionConfig.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var activeTrustedSigners: ActiveTrustedSigners? = null
        override var arn: String? = null
        override var domainName: String? = null
        override var id: String? = null
        override var lastModifiedTime: Instant? = null
        override var status: String? = null
        override var streamingDistributionConfig: StreamingDistributionConfig? = null

        constructor(x: StreamingDistribution) : this() {
            this.activeTrustedSigners = x.activeTrustedSigners
            this.arn = x.arn
            this.domainName = x.domainName
            this.id = x.id
            this.lastModifiedTime = x.lastModifiedTime
            this.status = x.status
            this.streamingDistributionConfig = x.streamingDistributionConfig
        }

        override fun build(): StreamingDistribution = StreamingDistribution(this)
        override fun activeTrustedSigners(activeTrustedSigners: ActiveTrustedSigners): FluentBuilder = apply { this.activeTrustedSigners = activeTrustedSigners }
        override fun arn(arn: String): FluentBuilder = apply { this.arn = arn }
        override fun domainName(domainName: String): FluentBuilder = apply { this.domainName = domainName }
        override fun id(id: String): FluentBuilder = apply { this.id = id }
        override fun lastModifiedTime(lastModifiedTime: Instant): FluentBuilder = apply { this.lastModifiedTime = lastModifiedTime }
        override fun status(status: String): FluentBuilder = apply { this.status = status }
        override fun streamingDistributionConfig(streamingDistributionConfig: StreamingDistributionConfig): FluentBuilder = apply { this.streamingDistributionConfig = streamingDistributionConfig }
    }
}
