// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model



/**
 * A list of accounts and the active CloudFront key pairs in each account that CloudFront can use to
 * verify the signatures of signed URLs and signed cookies.
 */
class Signer private constructor(builder: BuilderImpl) {
    /**
     * An account number that contains active CloudFront key pairs that CloudFront can use to verify the
     * signatures of signed URLs and signed cookies. If the account that owns the key pairs
     * is the same account that owns the CloudFront distribution, the value of this field is
     * self.
     */
    val awsAccountNumber: String? = builder.awsAccountNumber
    /**
     * A list of CloudFront key pair identifiers.
     */
    val keyPairIds: KeyPairIds? = builder.keyPairIds

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Signer = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Signer(")
        append("awsAccountNumber=$awsAccountNumber,")
        append("keyPairIds=$keyPairIds)")
    }

    override fun hashCode(): kotlin.Int {
        var result = awsAccountNumber?.hashCode() ?: 0
        result = 31 * result + (keyPairIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Signer

        if (awsAccountNumber != other.awsAccountNumber) return false
        if (keyPairIds != other.keyPairIds) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Signer = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Signer
        /**
         * An account number that contains active CloudFront key pairs that CloudFront can use to verify the
         * signatures of signed URLs and signed cookies. If the account that owns the key pairs
         * is the same account that owns the CloudFront distribution, the value of this field is
         * self.
         */
        fun awsAccountNumber(awsAccountNumber: String): FluentBuilder
        /**
         * A list of CloudFront key pair identifiers.
         */
        fun keyPairIds(keyPairIds: KeyPairIds): FluentBuilder
    }

    interface DslBuilder {
        /**
         * An account number that contains active CloudFront key pairs that CloudFront can use to verify the
         * signatures of signed URLs and signed cookies. If the account that owns the key pairs
         * is the same account that owns the CloudFront distribution, the value of this field is
         * self.
         */
        var awsAccountNumber: String?
        /**
         * A list of CloudFront key pair identifiers.
         */
        var keyPairIds: KeyPairIds?

        fun build(): Signer
        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.KeyPairIds] inside the given [block]
         */
        fun keyPairIds(block: KeyPairIds.DslBuilder.() -> kotlin.Unit) {
            this.keyPairIds = KeyPairIds.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var awsAccountNumber: String? = null
        override var keyPairIds: KeyPairIds? = null

        constructor(x: Signer) : this() {
            this.awsAccountNumber = x.awsAccountNumber
            this.keyPairIds = x.keyPairIds
        }

        override fun build(): Signer = Signer(this)
        override fun awsAccountNumber(awsAccountNumber: String): FluentBuilder = apply { this.awsAccountNumber = awsAccountNumber }
        override fun keyPairIds(keyPairIds: KeyPairIds): FluentBuilder = apply { this.keyPairIds = keyPairIds }
    }
}
