// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model



/**
 * A complex type that contains information about the Amazon S3 origin. If the origin is a
 * custom origin or an S3 bucket that is configured as a website endpoint, use the
 * CustomOriginConfig element instead.
 */
class S3OriginConfig private constructor(builder: BuilderImpl) {
    /**
     * The CloudFront origin access identity to associate with the origin. Use an origin access
     * identity to configure the origin so that viewers can only access objects
     * in an Amazon S3 bucket through CloudFront. The format of the value is:
     * origin-access-identity/cloudfront/ID-of-origin-access-identity
     * where
     * ID-of-origin-access-identity
     * is the value that
     * CloudFront returned in the ID element when you created the origin access
     * identity.
     * If you want viewers to be able to access objects using either the CloudFront URL or the Amazon S3
     * URL, specify an empty OriginAccessIdentity element.
     * To delete the origin access identity from an existing distribution, update the
     * distribution configuration and include an empty OriginAccessIdentity
     * element.
     * To replace the origin access identity, update the distribution configuration and
     * specify the new origin access identity.
     * For more information about the origin access identity, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving Private Content through CloudFront in the
     * Amazon CloudFront Developer Guide.
     */
    val originAccessIdentity: String? = builder.originAccessIdentity

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): S3OriginConfig = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("S3OriginConfig(")
        append("originAccessIdentity=$originAccessIdentity)")
    }

    override fun hashCode(): kotlin.Int {
        var result = originAccessIdentity?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as S3OriginConfig

        if (originAccessIdentity != other.originAccessIdentity) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): S3OriginConfig = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): S3OriginConfig
        /**
         * The CloudFront origin access identity to associate with the origin. Use an origin access
         * identity to configure the origin so that viewers can only access objects
         * in an Amazon S3 bucket through CloudFront. The format of the value is:
         * origin-access-identity/cloudfront/ID-of-origin-access-identity
         * where
         * ID-of-origin-access-identity
         * is the value that
         * CloudFront returned in the ID element when you created the origin access
         * identity.
         * If you want viewers to be able to access objects using either the CloudFront URL or the Amazon S3
         * URL, specify an empty OriginAccessIdentity element.
         * To delete the origin access identity from an existing distribution, update the
         * distribution configuration and include an empty OriginAccessIdentity
         * element.
         * To replace the origin access identity, update the distribution configuration and
         * specify the new origin access identity.
         * For more information about the origin access identity, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving Private Content through CloudFront in the
         * Amazon CloudFront Developer Guide.
         */
        fun originAccessIdentity(originAccessIdentity: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The CloudFront origin access identity to associate with the origin. Use an origin access
         * identity to configure the origin so that viewers can only access objects
         * in an Amazon S3 bucket through CloudFront. The format of the value is:
         * origin-access-identity/cloudfront/ID-of-origin-access-identity
         * where
         * ID-of-origin-access-identity
         * is the value that
         * CloudFront returned in the ID element when you created the origin access
         * identity.
         * If you want viewers to be able to access objects using either the CloudFront URL or the Amazon S3
         * URL, specify an empty OriginAccessIdentity element.
         * To delete the origin access identity from an existing distribution, update the
         * distribution configuration and include an empty OriginAccessIdentity
         * element.
         * To replace the origin access identity, update the distribution configuration and
         * specify the new origin access identity.
         * For more information about the origin access identity, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving Private Content through CloudFront in the
         * Amazon CloudFront Developer Guide.
         */
        var originAccessIdentity: String?

        fun build(): S3OriginConfig
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var originAccessIdentity: String? = null

        constructor(x: S3OriginConfig) : this() {
            this.originAccessIdentity = x.originAccessIdentity
        }

        override fun build(): S3OriginConfig = S3OriginConfig(this)
        override fun originAccessIdentity(originAccessIdentity: String): FluentBuilder = apply { this.originAccessIdentity = originAccessIdentity }
    }
}
