// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model



/**
 * A complex type that contains information about the Amazon S3 bucket from which you want
 * CloudFront to get your media files for distribution.
 */
class S3Origin private constructor(builder: BuilderImpl) {
    /**
     * The DNS name of the Amazon S3 origin.
     */
    val domainName: String? = builder.domainName
    /**
     * The CloudFront origin access identity to associate with the distribution. Use an origin
     * access identity to configure the distribution so that end users can only access objects in an
     * Amazon S3 bucket through CloudFront.
     * If you want end users to be able to access objects using either the CloudFront URL or the
     * Amazon S3 URL, specify an empty OriginAccessIdentity element.
     * To delete the origin access identity from an existing distribution, update the
     * distribution configuration and include an empty OriginAccessIdentity
     * element.
     * To replace the origin access identity, update the distribution configuration and
     * specify the new origin access identity.
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-s3.html">Using an Origin Access
     * Identity to Restrict Access to Your Amazon S3 Content in the
     * Amazon CloudFront Developer Guide.
     */
    val originAccessIdentity: String? = builder.originAccessIdentity

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): S3Origin = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("S3Origin(")
        append("domainName=$domainName,")
        append("originAccessIdentity=$originAccessIdentity)")
    }

    override fun hashCode(): kotlin.Int {
        var result = domainName?.hashCode() ?: 0
        result = 31 * result + (originAccessIdentity?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as S3Origin

        if (domainName != other.domainName) return false
        if (originAccessIdentity != other.originAccessIdentity) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): S3Origin = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): S3Origin
        /**
         * The DNS name of the Amazon S3 origin.
         */
        fun domainName(domainName: String): FluentBuilder
        /**
         * The CloudFront origin access identity to associate with the distribution. Use an origin
         * access identity to configure the distribution so that end users can only access objects in an
         * Amazon S3 bucket through CloudFront.
         * If you want end users to be able to access objects using either the CloudFront URL or the
         * Amazon S3 URL, specify an empty OriginAccessIdentity element.
         * To delete the origin access identity from an existing distribution, update the
         * distribution configuration and include an empty OriginAccessIdentity
         * element.
         * To replace the origin access identity, update the distribution configuration and
         * specify the new origin access identity.
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-s3.html">Using an Origin Access
         * Identity to Restrict Access to Your Amazon S3 Content in the
         * Amazon CloudFront Developer Guide.
         */
        fun originAccessIdentity(originAccessIdentity: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The DNS name of the Amazon S3 origin.
         */
        var domainName: String?
        /**
         * The CloudFront origin access identity to associate with the distribution. Use an origin
         * access identity to configure the distribution so that end users can only access objects in an
         * Amazon S3 bucket through CloudFront.
         * If you want end users to be able to access objects using either the CloudFront URL or the
         * Amazon S3 URL, specify an empty OriginAccessIdentity element.
         * To delete the origin access identity from an existing distribution, update the
         * distribution configuration and include an empty OriginAccessIdentity
         * element.
         * To replace the origin access identity, update the distribution configuration and
         * specify the new origin access identity.
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-s3.html">Using an Origin Access
         * Identity to Restrict Access to Your Amazon S3 Content in the
         * Amazon CloudFront Developer Guide.
         */
        var originAccessIdentity: String?

        fun build(): S3Origin
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var domainName: String? = null
        override var originAccessIdentity: String? = null

        constructor(x: S3Origin) : this() {
            this.domainName = x.domainName
            this.originAccessIdentity = x.originAccessIdentity
        }

        override fun build(): S3Origin = S3Origin(this)
        override fun domainName(domainName: String): FluentBuilder = apply { this.domainName = domainName }
        override fun originAccessIdentity(originAccessIdentity: String): FluentBuilder = apply { this.originAccessIdentity = originAccessIdentity }
    }
}
