// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model



/**
 * A list of real-time log configurations.
 */
class RealtimeLogConfigs private constructor(builder: BuilderImpl) {
    /**
     * A flag that indicates whether there are more real-time log configurations than are contained
     * in this list.
     */
    val isTruncated: Boolean? = builder.isTruncated
    /**
     * Contains the list of real-time log configurations.
     */
    val items: List<RealtimeLogConfig>? = builder.items
    /**
     * This parameter indicates where this list of real-time log configurations begins. This list
     * includes real-time log configurations that occur after the marker.
     */
    val marker: String? = builder.marker
    /**
     * The maximum number of real-time log configurations requested.
     */
    val maxItems: Int? = builder.maxItems
    /**
     * If there are more items in the list than are in this response, this element is present. It
     * contains the value that you should use in the Marker field of a subsequent
     * request to continue listing real-time log configurations where you left off.
     */
    val nextMarker: String? = builder.nextMarker

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): RealtimeLogConfigs = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("RealtimeLogConfigs(")
        append("isTruncated=$isTruncated,")
        append("items=$items,")
        append("marker=$marker,")
        append("maxItems=$maxItems,")
        append("nextMarker=$nextMarker)")
    }

    override fun hashCode(): kotlin.Int {
        var result = isTruncated?.hashCode() ?: 0
        result = 31 * result + (items?.hashCode() ?: 0)
        result = 31 * result + (marker?.hashCode() ?: 0)
        result = 31 * result + (maxItems ?: 0)
        result = 31 * result + (nextMarker?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as RealtimeLogConfigs

        if (isTruncated != other.isTruncated) return false
        if (items != other.items) return false
        if (marker != other.marker) return false
        if (maxItems != other.maxItems) return false
        if (nextMarker != other.nextMarker) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): RealtimeLogConfigs = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): RealtimeLogConfigs
        /**
         * A flag that indicates whether there are more real-time log configurations than are contained
         * in this list.
         */
        fun isTruncated(isTruncated: Boolean): FluentBuilder
        /**
         * Contains the list of real-time log configurations.
         */
        fun items(items: List<RealtimeLogConfig>): FluentBuilder
        /**
         * This parameter indicates where this list of real-time log configurations begins. This list
         * includes real-time log configurations that occur after the marker.
         */
        fun marker(marker: String): FluentBuilder
        /**
         * The maximum number of real-time log configurations requested.
         */
        fun maxItems(maxItems: Int): FluentBuilder
        /**
         * If there are more items in the list than are in this response, this element is present. It
         * contains the value that you should use in the Marker field of a subsequent
         * request to continue listing real-time log configurations where you left off.
         */
        fun nextMarker(nextMarker: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A flag that indicates whether there are more real-time log configurations than are contained
         * in this list.
         */
        var isTruncated: Boolean?
        /**
         * Contains the list of real-time log configurations.
         */
        var items: List<RealtimeLogConfig>?
        /**
         * This parameter indicates where this list of real-time log configurations begins. This list
         * includes real-time log configurations that occur after the marker.
         */
        var marker: String?
        /**
         * The maximum number of real-time log configurations requested.
         */
        var maxItems: Int?
        /**
         * If there are more items in the list than are in this response, this element is present. It
         * contains the value that you should use in the Marker field of a subsequent
         * request to continue listing real-time log configurations where you left off.
         */
        var nextMarker: String?

        fun build(): RealtimeLogConfigs
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var isTruncated: Boolean? = null
        override var items: List<RealtimeLogConfig>? = null
        override var marker: String? = null
        override var maxItems: Int? = null
        override var nextMarker: String? = null

        constructor(x: RealtimeLogConfigs) : this() {
            this.isTruncated = x.isTruncated
            this.items = x.items
            this.marker = x.marker
            this.maxItems = x.maxItems
            this.nextMarker = x.nextMarker
        }

        override fun build(): RealtimeLogConfigs = RealtimeLogConfigs(this)
        override fun isTruncated(isTruncated: Boolean): FluentBuilder = apply { this.isTruncated = isTruncated }
        override fun items(items: List<RealtimeLogConfig>): FluentBuilder = apply { this.items = items }
        override fun marker(marker: String): FluentBuilder = apply { this.marker = marker }
        override fun maxItems(maxItems: Int): FluentBuilder = apply { this.maxItems = maxItems }
        override fun nextMarker(nextMarker: String): FluentBuilder = apply { this.nextMarker = nextMarker }
    }
}
