// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model



/**
 * A real-time log configuration.
 */
class RealtimeLogConfig private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Resource Name (ARN) of this real-time log configuration.
     */
    val arn: String? = builder.arn
    /**
     * Contains information about the Amazon Kinesis data stream where you are sending real-time
     * log data for this real-time log configuration.
     */
    val endPoints: List<EndPoint>? = builder.endPoints
    /**
     * A list of fields that are included in each real-time log record. In an API response, the
     * fields are provided in the same order in which they are sent to the Amazon Kinesis data
     * stream.
     * For more information about fields, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-fields">Real-time log configuration fields in the
     * Amazon CloudFront Developer Guide.
     */
    val fields: List<String>? = builder.fields
    /**
     * The unique name of this real-time log configuration.
     */
    val name: String? = builder.name
    /**
     * The sampling rate for this real-time log configuration. The sampling rate determines the
     * percentage of viewer requests that are represented in the real-time log data. The
     * sampling rate is an integer between 1 and 100, inclusive.
     */
    val samplingRate: Long? = builder.samplingRate

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): RealtimeLogConfig = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("RealtimeLogConfig(")
        append("arn=$arn,")
        append("endPoints=$endPoints,")
        append("fields=$fields,")
        append("name=$name,")
        append("samplingRate=$samplingRate)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (endPoints?.hashCode() ?: 0)
        result = 31 * result + (fields?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (samplingRate?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as RealtimeLogConfig

        if (arn != other.arn) return false
        if (endPoints != other.endPoints) return false
        if (fields != other.fields) return false
        if (name != other.name) return false
        if (samplingRate != other.samplingRate) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): RealtimeLogConfig = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): RealtimeLogConfig
        /**
         * The Amazon Resource Name (ARN) of this real-time log configuration.
         */
        fun arn(arn: String): FluentBuilder
        /**
         * Contains information about the Amazon Kinesis data stream where you are sending real-time
         * log data for this real-time log configuration.
         */
        fun endPoints(endPoints: List<EndPoint>): FluentBuilder
        /**
         * A list of fields that are included in each real-time log record. In an API response, the
         * fields are provided in the same order in which they are sent to the Amazon Kinesis data
         * stream.
         * For more information about fields, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-fields">Real-time log configuration fields in the
         * Amazon CloudFront Developer Guide.
         */
        fun fields(fields: List<String>): FluentBuilder
        /**
         * The unique name of this real-time log configuration.
         */
        fun name(name: String): FluentBuilder
        /**
         * The sampling rate for this real-time log configuration. The sampling rate determines the
         * percentage of viewer requests that are represented in the real-time log data. The
         * sampling rate is an integer between 1 and 100, inclusive.
         */
        fun samplingRate(samplingRate: Long): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Resource Name (ARN) of this real-time log configuration.
         */
        var arn: String?
        /**
         * Contains information about the Amazon Kinesis data stream where you are sending real-time
         * log data for this real-time log configuration.
         */
        var endPoints: List<EndPoint>?
        /**
         * A list of fields that are included in each real-time log record. In an API response, the
         * fields are provided in the same order in which they are sent to the Amazon Kinesis data
         * stream.
         * For more information about fields, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-fields">Real-time log configuration fields in the
         * Amazon CloudFront Developer Guide.
         */
        var fields: List<String>?
        /**
         * The unique name of this real-time log configuration.
         */
        var name: String?
        /**
         * The sampling rate for this real-time log configuration. The sampling rate determines the
         * percentage of viewer requests that are represented in the real-time log data. The
         * sampling rate is an integer between 1 and 100, inclusive.
         */
        var samplingRate: Long?

        fun build(): RealtimeLogConfig
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var arn: String? = null
        override var endPoints: List<EndPoint>? = null
        override var fields: List<String>? = null
        override var name: String? = null
        override var samplingRate: Long? = null

        constructor(x: RealtimeLogConfig) : this() {
            this.arn = x.arn
            this.endPoints = x.endPoints
            this.fields = x.fields
            this.name = x.name
            this.samplingRate = x.samplingRate
        }

        override fun build(): RealtimeLogConfig = RealtimeLogConfig(this)
        override fun arn(arn: String): FluentBuilder = apply { this.arn = arn }
        override fun endPoints(endPoints: List<EndPoint>): FluentBuilder = apply { this.endPoints = endPoints }
        override fun fields(fields: List<String>): FluentBuilder = apply { this.fields = fields }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun samplingRate(samplingRate: Long): FluentBuilder = apply { this.samplingRate = samplingRate }
    }
}
