// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about a public key.
 */
class PublicKeySummary private constructor(builder: BuilderImpl) {
    /**
     * A comment to describe the public key. The comment cannot be longer than 128
     * characters.
     */
    val comment: String? = builder.comment
    /**
     * The date and time when the public key was uploaded.
     */
    val createdTime: Instant? = builder.createdTime
    /**
     * The public key.
     */
    val encodedKey: String? = builder.encodedKey
    /**
     * The identifier of the public key.
     */
    val id: String? = builder.id
    /**
     * A name to help identify the public key.
     */
    val name: String? = builder.name

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): PublicKeySummary = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("PublicKeySummary(")
        append("comment=$comment,")
        append("createdTime=$createdTime,")
        append("encodedKey=$encodedKey,")
        append("id=$id,")
        append("name=$name)")
    }

    override fun hashCode(): kotlin.Int {
        var result = comment?.hashCode() ?: 0
        result = 31 * result + (createdTime?.hashCode() ?: 0)
        result = 31 * result + (encodedKey?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as PublicKeySummary

        if (comment != other.comment) return false
        if (createdTime != other.createdTime) return false
        if (encodedKey != other.encodedKey) return false
        if (id != other.id) return false
        if (name != other.name) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): PublicKeySummary = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): PublicKeySummary
        /**
         * A comment to describe the public key. The comment cannot be longer than 128
         * characters.
         */
        fun comment(comment: String): FluentBuilder
        /**
         * The date and time when the public key was uploaded.
         */
        fun createdTime(createdTime: Instant): FluentBuilder
        /**
         * The public key.
         */
        fun encodedKey(encodedKey: String): FluentBuilder
        /**
         * The identifier of the public key.
         */
        fun id(id: String): FluentBuilder
        /**
         * A name to help identify the public key.
         */
        fun name(name: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A comment to describe the public key. The comment cannot be longer than 128
         * characters.
         */
        var comment: String?
        /**
         * The date and time when the public key was uploaded.
         */
        var createdTime: Instant?
        /**
         * The public key.
         */
        var encodedKey: String?
        /**
         * The identifier of the public key.
         */
        var id: String?
        /**
         * A name to help identify the public key.
         */
        var name: String?

        fun build(): PublicKeySummary
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var comment: String? = null
        override var createdTime: Instant? = null
        override var encodedKey: String? = null
        override var id: String? = null
        override var name: String? = null

        constructor(x: PublicKeySummary) : this() {
            this.comment = x.comment
            this.createdTime = x.createdTime
            this.encodedKey = x.encodedKey
            this.id = x.id
            this.name = x.name
        }

        override fun build(): PublicKeySummary = PublicKeySummary(this)
        override fun comment(comment: String): FluentBuilder = apply { this.comment = comment }
        override fun createdTime(createdTime: Instant): FluentBuilder = apply { this.createdTime = createdTime }
        override fun encodedKey(encodedKey: String): FluentBuilder = apply { this.encodedKey = encodedKey }
        override fun id(id: String): FluentBuilder = apply { this.id = id }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
    }
}
