// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model



/**
 * A list of public keys that you can use with <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">signed URLs and signed cookies, or with <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/field-level-encryption.html">field-level encryption.
 */
class PublicKeyList private constructor(builder: BuilderImpl) {
    /**
     * A list of public keys.
     */
    val items: List<PublicKeySummary>? = builder.items
    /**
     * The maximum number of public keys you want in the response.
     */
    val maxItems: Int? = builder.maxItems
    /**
     * If there are more elements to be listed, this element is present and contains
     * the value that you can use for the Marker request parameter to continue
     * listing your public keys where you left off.
     */
    val nextMarker: String? = builder.nextMarker
    /**
     * The number of public keys in the list.
     */
    val quantity: Int? = builder.quantity

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): PublicKeyList = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("PublicKeyList(")
        append("items=$items,")
        append("maxItems=$maxItems,")
        append("nextMarker=$nextMarker,")
        append("quantity=$quantity)")
    }

    override fun hashCode(): kotlin.Int {
        var result = items?.hashCode() ?: 0
        result = 31 * result + (maxItems ?: 0)
        result = 31 * result + (nextMarker?.hashCode() ?: 0)
        result = 31 * result + (quantity ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as PublicKeyList

        if (items != other.items) return false
        if (maxItems != other.maxItems) return false
        if (nextMarker != other.nextMarker) return false
        if (quantity != other.quantity) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): PublicKeyList = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): PublicKeyList
        /**
         * A list of public keys.
         */
        fun items(items: List<PublicKeySummary>): FluentBuilder
        /**
         * The maximum number of public keys you want in the response.
         */
        fun maxItems(maxItems: Int): FluentBuilder
        /**
         * If there are more elements to be listed, this element is present and contains
         * the value that you can use for the Marker request parameter to continue
         * listing your public keys where you left off.
         */
        fun nextMarker(nextMarker: String): FluentBuilder
        /**
         * The number of public keys in the list.
         */
        fun quantity(quantity: Int): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A list of public keys.
         */
        var items: List<PublicKeySummary>?
        /**
         * The maximum number of public keys you want in the response.
         */
        var maxItems: Int?
        /**
         * If there are more elements to be listed, this element is present and contains
         * the value that you can use for the Marker request parameter to continue
         * listing your public keys where you left off.
         */
        var nextMarker: String?
        /**
         * The number of public keys in the list.
         */
        var quantity: Int?

        fun build(): PublicKeyList
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var items: List<PublicKeySummary>? = null
        override var maxItems: Int? = null
        override var nextMarker: String? = null
        override var quantity: Int? = null

        constructor(x: PublicKeyList) : this() {
            this.items = x.items
            this.maxItems = x.maxItems
            this.nextMarker = x.nextMarker
            this.quantity = x.quantity
        }

        override fun build(): PublicKeyList = PublicKeyList(this)
        override fun items(items: List<PublicKeySummary>): FluentBuilder = apply { this.items = items }
        override fun maxItems(maxItems: Int): FluentBuilder = apply { this.maxItems = maxItems }
        override fun nextMarker(nextMarker: String): FluentBuilder = apply { this.nextMarker = nextMarker }
        override fun quantity(quantity: Int): FluentBuilder = apply { this.quantity = quantity }
    }
}
