// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model



/**
 * Configuration information about a public key that you can use with <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">signed URLs and signed cookies, or with <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/field-level-encryption.html">field-level encryption.
 */
class PublicKeyConfig private constructor(builder: BuilderImpl) {
    /**
     * A string included in the request to help make sure that the request can’t be
     * replayed.
     */
    val callerReference: String? = builder.callerReference
    /**
     * A comment to describe the public key. The comment cannot be longer than 128
     * characters.
     */
    val comment: String? = builder.comment
    /**
     * The public key that you can use with <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">signed URLs and signed cookies, or with <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/field-level-encryption.html">field-level encryption.
     */
    val encodedKey: String? = builder.encodedKey
    /**
     * A name to help identify the public key.
     */
    val name: String? = builder.name

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): PublicKeyConfig = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("PublicKeyConfig(")
        append("callerReference=$callerReference,")
        append("comment=$comment,")
        append("encodedKey=$encodedKey,")
        append("name=$name)")
    }

    override fun hashCode(): kotlin.Int {
        var result = callerReference?.hashCode() ?: 0
        result = 31 * result + (comment?.hashCode() ?: 0)
        result = 31 * result + (encodedKey?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as PublicKeyConfig

        if (callerReference != other.callerReference) return false
        if (comment != other.comment) return false
        if (encodedKey != other.encodedKey) return false
        if (name != other.name) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): PublicKeyConfig = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): PublicKeyConfig
        /**
         * A string included in the request to help make sure that the request can’t be
         * replayed.
         */
        fun callerReference(callerReference: String): FluentBuilder
        /**
         * A comment to describe the public key. The comment cannot be longer than 128
         * characters.
         */
        fun comment(comment: String): FluentBuilder
        /**
         * The public key that you can use with <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">signed URLs and signed cookies, or with <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/field-level-encryption.html">field-level encryption.
         */
        fun encodedKey(encodedKey: String): FluentBuilder
        /**
         * A name to help identify the public key.
         */
        fun name(name: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A string included in the request to help make sure that the request can’t be
         * replayed.
         */
        var callerReference: String?
        /**
         * A comment to describe the public key. The comment cannot be longer than 128
         * characters.
         */
        var comment: String?
        /**
         * The public key that you can use with <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">signed URLs and signed cookies, or with <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/field-level-encryption.html">field-level encryption.
         */
        var encodedKey: String?
        /**
         * A name to help identify the public key.
         */
        var name: String?

        fun build(): PublicKeyConfig
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var callerReference: String? = null
        override var comment: String? = null
        override var encodedKey: String? = null
        override var name: String? = null

        constructor(x: PublicKeyConfig) : this() {
            this.callerReference = x.callerReference
            this.comment = x.comment
            this.encodedKey = x.encodedKey
            this.name = x.name
        }

        override fun build(): PublicKeyConfig = PublicKeyConfig(this)
        override fun callerReference(callerReference: String): FluentBuilder = apply { this.callerReference = callerReference }
        override fun comment(comment: String): FluentBuilder = apply { this.comment = comment }
        override fun encodedKey(encodedKey: String): FluentBuilder = apply { this.encodedKey = encodedKey }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
    }
}
