// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A public key that you can use with <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">signed URLs and signed cookies, or with <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/field-level-encryption.html">field-level encryption.
 */
class PublicKey private constructor(builder: BuilderImpl) {
    /**
     * The date and time when the public key was uploaded.
     */
    val createdTime: Instant? = builder.createdTime
    /**
     * The identifier of the public key.
     */
    val id: String? = builder.id
    /**
     * Configuration information about a public key that you can use with <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">signed URLs and signed cookies, or with <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/field-level-encryption.html">field-level encryption.
     */
    val publicKeyConfig: PublicKeyConfig? = builder.publicKeyConfig

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): PublicKey = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("PublicKey(")
        append("createdTime=$createdTime,")
        append("id=$id,")
        append("publicKeyConfig=$publicKeyConfig)")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdTime?.hashCode() ?: 0
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (publicKeyConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as PublicKey

        if (createdTime != other.createdTime) return false
        if (id != other.id) return false
        if (publicKeyConfig != other.publicKeyConfig) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): PublicKey = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): PublicKey
        /**
         * The date and time when the public key was uploaded.
         */
        fun createdTime(createdTime: Instant): FluentBuilder
        /**
         * The identifier of the public key.
         */
        fun id(id: String): FluentBuilder
        /**
         * Configuration information about a public key that you can use with <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">signed URLs and signed cookies, or with <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/field-level-encryption.html">field-level encryption.
         */
        fun publicKeyConfig(publicKeyConfig: PublicKeyConfig): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The date and time when the public key was uploaded.
         */
        var createdTime: Instant?
        /**
         * The identifier of the public key.
         */
        var id: String?
        /**
         * Configuration information about a public key that you can use with <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">signed URLs and signed cookies, or with <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/field-level-encryption.html">field-level encryption.
         */
        var publicKeyConfig: PublicKeyConfig?

        fun build(): PublicKey
        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.PublicKeyConfig] inside the given [block]
         */
        fun publicKeyConfig(block: PublicKeyConfig.DslBuilder.() -> kotlin.Unit) {
            this.publicKeyConfig = PublicKeyConfig.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var createdTime: Instant? = null
        override var id: String? = null
        override var publicKeyConfig: PublicKeyConfig? = null

        constructor(x: PublicKey) : this() {
            this.createdTime = x.createdTime
            this.id = x.id
            this.publicKeyConfig = x.publicKeyConfig
        }

        override fun build(): PublicKey = PublicKey(this)
        override fun createdTime(createdTime: Instant): FluentBuilder = apply { this.createdTime = createdTime }
        override fun id(id: String): FluentBuilder = apply { this.id = id }
        override fun publicKeyConfig(publicKeyConfig: PublicKeyConfig): FluentBuilder = apply { this.publicKeyConfig = publicKeyConfig }
    }
}
