// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model



/**
 * A complex type that contains information about the objects that you want to invalidate.
 * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Invalidation.html#invalidation-specifying-objects">Specifying the Objects
 * to Invalidate in the Amazon CloudFront Developer Guide.
 */
class Paths private constructor(builder: BuilderImpl) {
    /**
     * A complex type that contains a list of the paths that you want to invalidate.
     */
    val items: List<String>? = builder.items
    /**
     * The number of invalidation paths specified for the objects that you want to invalidate.
     */
    val quantity: Int? = builder.quantity

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Paths = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Paths(")
        append("items=$items,")
        append("quantity=$quantity)")
    }

    override fun hashCode(): kotlin.Int {
        var result = items?.hashCode() ?: 0
        result = 31 * result + (quantity ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Paths

        if (items != other.items) return false
        if (quantity != other.quantity) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Paths = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Paths
        /**
         * A complex type that contains a list of the paths that you want to invalidate.
         */
        fun items(items: List<String>): FluentBuilder
        /**
         * The number of invalidation paths specified for the objects that you want to invalidate.
         */
        fun quantity(quantity: Int): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A complex type that contains a list of the paths that you want to invalidate.
         */
        var items: List<String>?
        /**
         * The number of invalidation paths specified for the objects that you want to invalidate.
         */
        var quantity: Int?

        fun build(): Paths
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var items: List<String>? = null
        override var quantity: Int? = null

        constructor(x: Paths) : this() {
            this.items = x.items
            this.quantity = x.quantity
        }

        override fun build(): Paths = Paths(this)
        override fun items(items: List<String>): FluentBuilder = apply { this.items = items }
        override fun quantity(quantity: Int): FluentBuilder = apply { this.quantity = quantity }
    }
}
