// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model



/**
 * This object determines the values that CloudFront includes in the cache key. These values can
 * include HTTP headers, cookies, and URL query strings. CloudFront uses the cache key to find an
 * object in its cache that it can return to the viewer.
 * The headers, cookies, and query strings that are included in the cache key are automatically
 * included in requests that CloudFront sends to the origin. CloudFront sends a request when it can’t
 * find an object in its cache that matches the request’s cache key. If you want to send
 * values to the origin but not include them in the cache key, use
 * OriginRequestPolicy.
 */
class ParametersInCacheKeyAndForwardedToOrigin private constructor(builder: BuilderImpl) {
    /**
     * An object that determines whether any cookies in viewer requests (and if so, which cookies)
     * are included in the cache key and automatically included in requests that CloudFront sends to
     * the origin.
     */
    val cookiesConfig: CachePolicyCookiesConfig? = builder.cookiesConfig
    /**
     * A flag that can affect whether the Accept-Encoding HTTP header is
     * included in the cache key and included in requests that CloudFront sends to the origin.
     * This field is related to the EnableAcceptEncodingGzip field. If one or
     * both of these fields is true
     * and the viewer request
     * includes the Accept-Encoding header, then CloudFront does the following:
     * Normalizes the value of the viewer’s Accept-Encoding
     * header
     * Includes the normalized header in the cache key
     * Includes the normalized header in the request to the origin, if a request is necessary
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-policy-compressed-objects">Compression support in the
     * Amazon CloudFront Developer Guide.
     * If you set this value to true, and this cache behavior also has an origin
     * request policy attached, do not include the Accept-Encoding header in the
     * origin request policy. CloudFront always includes the Accept-Encoding header in
     * origin requests when the value of this field is true, so including this
     * header in an origin request policy has no effect.
     * If both of these fields are false, then CloudFront treats the
     * Accept-Encoding header the same as any other HTTP header in the viewer
     * request. By default, it’s not included in the cache key and it’s not included in origin
     * requests. In this case, you can manually add Accept-Encoding to the headers
     * whitelist like any other HTTP header.
     */
    val enableAcceptEncodingBrotli: Boolean? = builder.enableAcceptEncodingBrotli
    /**
     * A flag that can affect whether the Accept-Encoding HTTP header is
     * included in the cache key and included in requests that CloudFront sends to the origin.
     * This field is related to the EnableAcceptEncodingBrotli field. If one or
     * both of these fields is true
     * and the viewer request
     * includes the Accept-Encoding header, then CloudFront does the following:
     * Normalizes the value of the viewer’s Accept-Encoding
     * header
     * Includes the normalized header in the cache key
     * Includes the normalized header in the request to the origin, if a request is necessary
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-policy-compressed-objects">Compression support in the
     * Amazon CloudFront Developer Guide.
     * If you set this value to true, and this cache behavior also has an origin
     * request policy attached, do not include the Accept-Encoding header in the
     * origin request policy. CloudFront always includes the Accept-Encoding header in
     * origin requests when the value of this field is true, so including this
     * header in an origin request policy has no effect.
     * If both of these fields are false, then CloudFront treats the
     * Accept-Encoding header the same as any other HTTP header in the viewer
     * request. By default, it’s not included in the cache key and it’s not included in origin
     * requests. In this case, you can manually add Accept-Encoding to the headers
     * whitelist like any other HTTP header.
     */
    val enableAcceptEncodingGzip: Boolean? = builder.enableAcceptEncodingGzip
    /**
     * An object that determines whether any HTTP headers (and if so, which headers) are
     * included in the cache key and automatically included in requests that CloudFront sends to the
     * origin.
     */
    val headersConfig: CachePolicyHeadersConfig? = builder.headersConfig
    /**
     * An object that determines whether any URL query strings in viewer requests (and if so, which
     * query strings) are included in the cache key and automatically included in requests that
     * CloudFront sends to the origin.
     */
    val queryStringsConfig: CachePolicyQueryStringsConfig? = builder.queryStringsConfig

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ParametersInCacheKeyAndForwardedToOrigin = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ParametersInCacheKeyAndForwardedToOrigin(")
        append("cookiesConfig=$cookiesConfig,")
        append("enableAcceptEncodingBrotli=$enableAcceptEncodingBrotli,")
        append("enableAcceptEncodingGzip=$enableAcceptEncodingGzip,")
        append("headersConfig=$headersConfig,")
        append("queryStringsConfig=$queryStringsConfig)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cookiesConfig?.hashCode() ?: 0
        result = 31 * result + (enableAcceptEncodingBrotli?.hashCode() ?: 0)
        result = 31 * result + (enableAcceptEncodingGzip?.hashCode() ?: 0)
        result = 31 * result + (headersConfig?.hashCode() ?: 0)
        result = 31 * result + (queryStringsConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ParametersInCacheKeyAndForwardedToOrigin

        if (cookiesConfig != other.cookiesConfig) return false
        if (enableAcceptEncodingBrotli != other.enableAcceptEncodingBrotli) return false
        if (enableAcceptEncodingGzip != other.enableAcceptEncodingGzip) return false
        if (headersConfig != other.headersConfig) return false
        if (queryStringsConfig != other.queryStringsConfig) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ParametersInCacheKeyAndForwardedToOrigin = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ParametersInCacheKeyAndForwardedToOrigin
        /**
         * An object that determines whether any cookies in viewer requests (and if so, which cookies)
         * are included in the cache key and automatically included in requests that CloudFront sends to
         * the origin.
         */
        fun cookiesConfig(cookiesConfig: CachePolicyCookiesConfig): FluentBuilder
        /**
         * A flag that can affect whether the Accept-Encoding HTTP header is
         * included in the cache key and included in requests that CloudFront sends to the origin.
         * This field is related to the EnableAcceptEncodingGzip field. If one or
         * both of these fields is true
         * and the viewer request
         * includes the Accept-Encoding header, then CloudFront does the following:
         * Normalizes the value of the viewer’s Accept-Encoding
         * header
         * Includes the normalized header in the cache key
         * Includes the normalized header in the request to the origin, if a request is necessary
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-policy-compressed-objects">Compression support in the
         * Amazon CloudFront Developer Guide.
         * If you set this value to true, and this cache behavior also has an origin
         * request policy attached, do not include the Accept-Encoding header in the
         * origin request policy. CloudFront always includes the Accept-Encoding header in
         * origin requests when the value of this field is true, so including this
         * header in an origin request policy has no effect.
         * If both of these fields are false, then CloudFront treats the
         * Accept-Encoding header the same as any other HTTP header in the viewer
         * request. By default, it’s not included in the cache key and it’s not included in origin
         * requests. In this case, you can manually add Accept-Encoding to the headers
         * whitelist like any other HTTP header.
         */
        fun enableAcceptEncodingBrotli(enableAcceptEncodingBrotli: Boolean): FluentBuilder
        /**
         * A flag that can affect whether the Accept-Encoding HTTP header is
         * included in the cache key and included in requests that CloudFront sends to the origin.
         * This field is related to the EnableAcceptEncodingBrotli field. If one or
         * both of these fields is true
         * and the viewer request
         * includes the Accept-Encoding header, then CloudFront does the following:
         * Normalizes the value of the viewer’s Accept-Encoding
         * header
         * Includes the normalized header in the cache key
         * Includes the normalized header in the request to the origin, if a request is necessary
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-policy-compressed-objects">Compression support in the
         * Amazon CloudFront Developer Guide.
         * If you set this value to true, and this cache behavior also has an origin
         * request policy attached, do not include the Accept-Encoding header in the
         * origin request policy. CloudFront always includes the Accept-Encoding header in
         * origin requests when the value of this field is true, so including this
         * header in an origin request policy has no effect.
         * If both of these fields are false, then CloudFront treats the
         * Accept-Encoding header the same as any other HTTP header in the viewer
         * request. By default, it’s not included in the cache key and it’s not included in origin
         * requests. In this case, you can manually add Accept-Encoding to the headers
         * whitelist like any other HTTP header.
         */
        fun enableAcceptEncodingGzip(enableAcceptEncodingGzip: Boolean): FluentBuilder
        /**
         * An object that determines whether any HTTP headers (and if so, which headers) are
         * included in the cache key and automatically included in requests that CloudFront sends to the
         * origin.
         */
        fun headersConfig(headersConfig: CachePolicyHeadersConfig): FluentBuilder
        /**
         * An object that determines whether any URL query strings in viewer requests (and if so, which
         * query strings) are included in the cache key and automatically included in requests that
         * CloudFront sends to the origin.
         */
        fun queryStringsConfig(queryStringsConfig: CachePolicyQueryStringsConfig): FluentBuilder
    }

    interface DslBuilder {
        /**
         * An object that determines whether any cookies in viewer requests (and if so, which cookies)
         * are included in the cache key and automatically included in requests that CloudFront sends to
         * the origin.
         */
        var cookiesConfig: CachePolicyCookiesConfig?
        /**
         * A flag that can affect whether the Accept-Encoding HTTP header is
         * included in the cache key and included in requests that CloudFront sends to the origin.
         * This field is related to the EnableAcceptEncodingGzip field. If one or
         * both of these fields is true
         * and the viewer request
         * includes the Accept-Encoding header, then CloudFront does the following:
         * Normalizes the value of the viewer’s Accept-Encoding
         * header
         * Includes the normalized header in the cache key
         * Includes the normalized header in the request to the origin, if a request is necessary
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-policy-compressed-objects">Compression support in the
         * Amazon CloudFront Developer Guide.
         * If you set this value to true, and this cache behavior also has an origin
         * request policy attached, do not include the Accept-Encoding header in the
         * origin request policy. CloudFront always includes the Accept-Encoding header in
         * origin requests when the value of this field is true, so including this
         * header in an origin request policy has no effect.
         * If both of these fields are false, then CloudFront treats the
         * Accept-Encoding header the same as any other HTTP header in the viewer
         * request. By default, it’s not included in the cache key and it’s not included in origin
         * requests. In this case, you can manually add Accept-Encoding to the headers
         * whitelist like any other HTTP header.
         */
        var enableAcceptEncodingBrotli: Boolean?
        /**
         * A flag that can affect whether the Accept-Encoding HTTP header is
         * included in the cache key and included in requests that CloudFront sends to the origin.
         * This field is related to the EnableAcceptEncodingBrotli field. If one or
         * both of these fields is true
         * and the viewer request
         * includes the Accept-Encoding header, then CloudFront does the following:
         * Normalizes the value of the viewer’s Accept-Encoding
         * header
         * Includes the normalized header in the cache key
         * Includes the normalized header in the request to the origin, if a request is necessary
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-policy-compressed-objects">Compression support in the
         * Amazon CloudFront Developer Guide.
         * If you set this value to true, and this cache behavior also has an origin
         * request policy attached, do not include the Accept-Encoding header in the
         * origin request policy. CloudFront always includes the Accept-Encoding header in
         * origin requests when the value of this field is true, so including this
         * header in an origin request policy has no effect.
         * If both of these fields are false, then CloudFront treats the
         * Accept-Encoding header the same as any other HTTP header in the viewer
         * request. By default, it’s not included in the cache key and it’s not included in origin
         * requests. In this case, you can manually add Accept-Encoding to the headers
         * whitelist like any other HTTP header.
         */
        var enableAcceptEncodingGzip: Boolean?
        /**
         * An object that determines whether any HTTP headers (and if so, which headers) are
         * included in the cache key and automatically included in requests that CloudFront sends to the
         * origin.
         */
        var headersConfig: CachePolicyHeadersConfig?
        /**
         * An object that determines whether any URL query strings in viewer requests (and if so, which
         * query strings) are included in the cache key and automatically included in requests that
         * CloudFront sends to the origin.
         */
        var queryStringsConfig: CachePolicyQueryStringsConfig?

        fun build(): ParametersInCacheKeyAndForwardedToOrigin
        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.CachePolicyCookiesConfig] inside the given [block]
         */
        fun cookiesConfig(block: CachePolicyCookiesConfig.DslBuilder.() -> kotlin.Unit) {
            this.cookiesConfig = CachePolicyCookiesConfig.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.CachePolicyHeadersConfig] inside the given [block]
         */
        fun headersConfig(block: CachePolicyHeadersConfig.DslBuilder.() -> kotlin.Unit) {
            this.headersConfig = CachePolicyHeadersConfig.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.CachePolicyQueryStringsConfig] inside the given [block]
         */
        fun queryStringsConfig(block: CachePolicyQueryStringsConfig.DslBuilder.() -> kotlin.Unit) {
            this.queryStringsConfig = CachePolicyQueryStringsConfig.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var cookiesConfig: CachePolicyCookiesConfig? = null
        override var enableAcceptEncodingBrotli: Boolean? = null
        override var enableAcceptEncodingGzip: Boolean? = null
        override var headersConfig: CachePolicyHeadersConfig? = null
        override var queryStringsConfig: CachePolicyQueryStringsConfig? = null

        constructor(x: ParametersInCacheKeyAndForwardedToOrigin) : this() {
            this.cookiesConfig = x.cookiesConfig
            this.enableAcceptEncodingBrotli = x.enableAcceptEncodingBrotli
            this.enableAcceptEncodingGzip = x.enableAcceptEncodingGzip
            this.headersConfig = x.headersConfig
            this.queryStringsConfig = x.queryStringsConfig
        }

        override fun build(): ParametersInCacheKeyAndForwardedToOrigin = ParametersInCacheKeyAndForwardedToOrigin(this)
        override fun cookiesConfig(cookiesConfig: CachePolicyCookiesConfig): FluentBuilder = apply { this.cookiesConfig = cookiesConfig }
        override fun enableAcceptEncodingBrotli(enableAcceptEncodingBrotli: Boolean): FluentBuilder = apply { this.enableAcceptEncodingBrotli = enableAcceptEncodingBrotli }
        override fun enableAcceptEncodingGzip(enableAcceptEncodingGzip: Boolean): FluentBuilder = apply { this.enableAcceptEncodingGzip = enableAcceptEncodingGzip }
        override fun headersConfig(headersConfig: CachePolicyHeadersConfig): FluentBuilder = apply { this.headersConfig = headersConfig }
        override fun queryStringsConfig(queryStringsConfig: CachePolicyQueryStringsConfig): FluentBuilder = apply { this.queryStringsConfig = queryStringsConfig }
    }
}
