// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model



/**
 * A complex type that contains information about the SSL/TLS protocols that CloudFront can use
 * when establishing an HTTPS connection with your origin.
 */
class OriginSslProtocols private constructor(builder: BuilderImpl) {
    /**
     * A list that contains allowed SSL/TLS protocols for this distribution.
     */
    val items: List<SslProtocol>? = builder.items
    /**
     * The number of SSL/TLS protocols that you want to allow CloudFront to use when establishing an
     * HTTPS connection with this origin.
     */
    val quantity: Int? = builder.quantity

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): OriginSslProtocols = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("OriginSslProtocols(")
        append("items=$items,")
        append("quantity=$quantity)")
    }

    override fun hashCode(): kotlin.Int {
        var result = items?.hashCode() ?: 0
        result = 31 * result + (quantity ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as OriginSslProtocols

        if (items != other.items) return false
        if (quantity != other.quantity) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): OriginSslProtocols = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): OriginSslProtocols
        /**
         * A list that contains allowed SSL/TLS protocols for this distribution.
         */
        fun items(items: List<SslProtocol>): FluentBuilder
        /**
         * The number of SSL/TLS protocols that you want to allow CloudFront to use when establishing an
         * HTTPS connection with this origin.
         */
        fun quantity(quantity: Int): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A list that contains allowed SSL/TLS protocols for this distribution.
         */
        var items: List<SslProtocol>?
        /**
         * The number of SSL/TLS protocols that you want to allow CloudFront to use when establishing an
         * HTTPS connection with this origin.
         */
        var quantity: Int?

        fun build(): OriginSslProtocols
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var items: List<SslProtocol>? = null
        override var quantity: Int? = null

        constructor(x: OriginSslProtocols) : this() {
            this.items = x.items
            this.quantity = x.quantity
        }

        override fun build(): OriginSslProtocols = OriginSslProtocols(this)
        override fun items(items: List<SslProtocol>): FluentBuilder = apply { this.items = items }
        override fun quantity(quantity: Int): FluentBuilder = apply { this.quantity = quantity }
    }
}
