// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model



/**
 * CloudFront Origin Shield.
 * Using Origin Shield can help reduce the load on your origin. For more
 * information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/origin-shield.html">Using Origin Shield in the Amazon CloudFront Developer Guide.
 */
class OriginShield private constructor(builder: BuilderImpl) {
    /**
     * A flag that specifies whether Origin Shield is enabled.
     * When it’s enabled, CloudFront routes all requests through Origin Shield, which can
     * help protect your origin. When it’s disabled, CloudFront might send requests directly to
     * your origin from multiple edge locations or regional edge caches.
     */
    val enabled: Boolean? = builder.enabled
    /**
     * The Region for Origin Shield.
     * Specify the Region that has the lowest latency to your origin.
     * To specify a region, use the region code, not the region name.
     * For example, specify the US East (Ohio) region as us-east-2.
     * When you enable CloudFront Origin Shield, you must specify the Region for Origin
     * Shield. For the list of Regions that you can specify, and for help choosing the best
     * Region for your origin, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/origin-shield.html#choose-origin-shield-region">Choosing the Region for Origin Shield in the
     * Amazon CloudFront Developer Guide.
     */
    val originShieldRegion: String? = builder.originShieldRegion

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): OriginShield = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("OriginShield(")
        append("enabled=$enabled,")
        append("originShieldRegion=$originShieldRegion)")
    }

    override fun hashCode(): kotlin.Int {
        var result = enabled?.hashCode() ?: 0
        result = 31 * result + (originShieldRegion?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as OriginShield

        if (enabled != other.enabled) return false
        if (originShieldRegion != other.originShieldRegion) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): OriginShield = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): OriginShield
        /**
         * A flag that specifies whether Origin Shield is enabled.
         * When it’s enabled, CloudFront routes all requests through Origin Shield, which can
         * help protect your origin. When it’s disabled, CloudFront might send requests directly to
         * your origin from multiple edge locations or regional edge caches.
         */
        fun enabled(enabled: Boolean): FluentBuilder
        /**
         * The Region for Origin Shield.
         * Specify the Region that has the lowest latency to your origin.
         * To specify a region, use the region code, not the region name.
         * For example, specify the US East (Ohio) region as us-east-2.
         * When you enable CloudFront Origin Shield, you must specify the Region for Origin
         * Shield. For the list of Regions that you can specify, and for help choosing the best
         * Region for your origin, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/origin-shield.html#choose-origin-shield-region">Choosing the Region for Origin Shield in the
         * Amazon CloudFront Developer Guide.
         */
        fun originShieldRegion(originShieldRegion: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A flag that specifies whether Origin Shield is enabled.
         * When it’s enabled, CloudFront routes all requests through Origin Shield, which can
         * help protect your origin. When it’s disabled, CloudFront might send requests directly to
         * your origin from multiple edge locations or regional edge caches.
         */
        var enabled: Boolean?
        /**
         * The Region for Origin Shield.
         * Specify the Region that has the lowest latency to your origin.
         * To specify a region, use the region code, not the region name.
         * For example, specify the US East (Ohio) region as us-east-2.
         * When you enable CloudFront Origin Shield, you must specify the Region for Origin
         * Shield. For the list of Regions that you can specify, and for help choosing the best
         * Region for your origin, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/origin-shield.html#choose-origin-shield-region">Choosing the Region for Origin Shield in the
         * Amazon CloudFront Developer Guide.
         */
        var originShieldRegion: String?

        fun build(): OriginShield
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var enabled: Boolean? = null
        override var originShieldRegion: String? = null

        constructor(x: OriginShield) : this() {
            this.enabled = x.enabled
            this.originShieldRegion = x.originShieldRegion
        }

        override fun build(): OriginShield = OriginShield(this)
        override fun enabled(enabled: Boolean): FluentBuilder = apply { this.enabled = enabled }
        override fun originShieldRegion(originShieldRegion: String): FluentBuilder = apply { this.originShieldRegion = originShieldRegion }
    }
}
