// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model



/**
 * An object that determines whether any URL query strings in viewer requests (and if so, which
 * query strings) are included in requests that CloudFront sends to the origin.
 */
class OriginRequestPolicyQueryStringsConfig private constructor(builder: BuilderImpl) {
    /**
     * Determines whether any URL query strings in viewer requests are included in requests that
     * CloudFront sends to the origin. Valid values are:
     * none – Query strings in viewer requests are not included in requests that
     * CloudFront sends to the origin. Even when this field is set to none, any
     * query strings that are listed in a CachePolicy
     * are included in origin requests.
     * whitelist – The query strings in viewer requests that are listed in the
     * QueryStringNames type are included in requests that CloudFront sends to
     * the origin.
     * all – All query strings in viewer requests are included in requests that CloudFront
     * sends to the origin.
     */
    val queryStringBehavior: OriginRequestPolicyQueryStringBehavior? = builder.queryStringBehavior
    /**
     * Contains a list of the query strings in viewer requests that are included in requests that
     * CloudFront sends to the origin.
     */
    val queryStrings: QueryStringNames? = builder.queryStrings

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): OriginRequestPolicyQueryStringsConfig = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("OriginRequestPolicyQueryStringsConfig(")
        append("queryStringBehavior=$queryStringBehavior,")
        append("queryStrings=$queryStrings)")
    }

    override fun hashCode(): kotlin.Int {
        var result = queryStringBehavior?.hashCode() ?: 0
        result = 31 * result + (queryStrings?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as OriginRequestPolicyQueryStringsConfig

        if (queryStringBehavior != other.queryStringBehavior) return false
        if (queryStrings != other.queryStrings) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): OriginRequestPolicyQueryStringsConfig = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): OriginRequestPolicyQueryStringsConfig
        /**
         * Determines whether any URL query strings in viewer requests are included in requests that
         * CloudFront sends to the origin. Valid values are:
         * none – Query strings in viewer requests are not included in requests that
         * CloudFront sends to the origin. Even when this field is set to none, any
         * query strings that are listed in a CachePolicy
         * are included in origin requests.
         * whitelist – The query strings in viewer requests that are listed in the
         * QueryStringNames type are included in requests that CloudFront sends to
         * the origin.
         * all – All query strings in viewer requests are included in requests that CloudFront
         * sends to the origin.
         */
        fun queryStringBehavior(queryStringBehavior: OriginRequestPolicyQueryStringBehavior): FluentBuilder
        /**
         * Contains a list of the query strings in viewer requests that are included in requests that
         * CloudFront sends to the origin.
         */
        fun queryStrings(queryStrings: QueryStringNames): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Determines whether any URL query strings in viewer requests are included in requests that
         * CloudFront sends to the origin. Valid values are:
         * none – Query strings in viewer requests are not included in requests that
         * CloudFront sends to the origin. Even when this field is set to none, any
         * query strings that are listed in a CachePolicy
         * are included in origin requests.
         * whitelist – The query strings in viewer requests that are listed in the
         * QueryStringNames type are included in requests that CloudFront sends to
         * the origin.
         * all – All query strings in viewer requests are included in requests that CloudFront
         * sends to the origin.
         */
        var queryStringBehavior: OriginRequestPolicyQueryStringBehavior?
        /**
         * Contains a list of the query strings in viewer requests that are included in requests that
         * CloudFront sends to the origin.
         */
        var queryStrings: QueryStringNames?

        fun build(): OriginRequestPolicyQueryStringsConfig
        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.QueryStringNames] inside the given [block]
         */
        fun queryStrings(block: QueryStringNames.DslBuilder.() -> kotlin.Unit) {
            this.queryStrings = QueryStringNames.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var queryStringBehavior: OriginRequestPolicyQueryStringBehavior? = null
        override var queryStrings: QueryStringNames? = null

        constructor(x: OriginRequestPolicyQueryStringsConfig) : this() {
            this.queryStringBehavior = x.queryStringBehavior
            this.queryStrings = x.queryStrings
        }

        override fun build(): OriginRequestPolicyQueryStringsConfig = OriginRequestPolicyQueryStringsConfig(this)
        override fun queryStringBehavior(queryStringBehavior: OriginRequestPolicyQueryStringBehavior): FluentBuilder = apply { this.queryStringBehavior = queryStringBehavior }
        override fun queryStrings(queryStrings: QueryStringNames): FluentBuilder = apply { this.queryStrings = queryStrings }
    }
}
