// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model



/**
 * An object that determines whether any HTTP headers (and if so, which headers) are included
 * in requests that CloudFront sends to the origin.
 */
class OriginRequestPolicyHeadersConfig private constructor(builder: BuilderImpl) {
    /**
     * Determines whether any HTTP headers are included in requests that CloudFront sends to the origin.
     * Valid values are:
     * none – HTTP headers are not included in requests that CloudFront sends to the
     * origin. Even when this field is set to none, any headers that are
     * listed in a CachePolicy
     * are included in origin
     * requests.
     * whitelist – The HTTP headers that are listed in the Headers type
     * are included in requests that CloudFront sends to the origin.
     * allViewer – All HTTP headers in viewer requests are included in requests that
     * CloudFront sends to the origin.
     * allViewerAndWhitelistCloudFront – All HTTP headers in viewer requests and the
     * additional CloudFront headers that are listed in the Headers type are
     * included in requests that CloudFront sends to the origin. The additional headers are
     * added by CloudFront.
     */
    val headerBehavior: OriginRequestPolicyHeaderBehavior? = builder.headerBehavior
    /**
     * Contains a list of HTTP header names.
     */
    val headers: Headers? = builder.headers

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): OriginRequestPolicyHeadersConfig = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("OriginRequestPolicyHeadersConfig(")
        append("headerBehavior=$headerBehavior,")
        append("headers=$headers)")
    }

    override fun hashCode(): kotlin.Int {
        var result = headerBehavior?.hashCode() ?: 0
        result = 31 * result + (headers?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as OriginRequestPolicyHeadersConfig

        if (headerBehavior != other.headerBehavior) return false
        if (headers != other.headers) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): OriginRequestPolicyHeadersConfig = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): OriginRequestPolicyHeadersConfig
        /**
         * Determines whether any HTTP headers are included in requests that CloudFront sends to the origin.
         * Valid values are:
         * none – HTTP headers are not included in requests that CloudFront sends to the
         * origin. Even when this field is set to none, any headers that are
         * listed in a CachePolicy
         * are included in origin
         * requests.
         * whitelist – The HTTP headers that are listed in the Headers type
         * are included in requests that CloudFront sends to the origin.
         * allViewer – All HTTP headers in viewer requests are included in requests that
         * CloudFront sends to the origin.
         * allViewerAndWhitelistCloudFront – All HTTP headers in viewer requests and the
         * additional CloudFront headers that are listed in the Headers type are
         * included in requests that CloudFront sends to the origin. The additional headers are
         * added by CloudFront.
         */
        fun headerBehavior(headerBehavior: OriginRequestPolicyHeaderBehavior): FluentBuilder
        /**
         * Contains a list of HTTP header names.
         */
        fun headers(headers: Headers): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Determines whether any HTTP headers are included in requests that CloudFront sends to the origin.
         * Valid values are:
         * none – HTTP headers are not included in requests that CloudFront sends to the
         * origin. Even when this field is set to none, any headers that are
         * listed in a CachePolicy
         * are included in origin
         * requests.
         * whitelist – The HTTP headers that are listed in the Headers type
         * are included in requests that CloudFront sends to the origin.
         * allViewer – All HTTP headers in viewer requests are included in requests that
         * CloudFront sends to the origin.
         * allViewerAndWhitelistCloudFront – All HTTP headers in viewer requests and the
         * additional CloudFront headers that are listed in the Headers type are
         * included in requests that CloudFront sends to the origin. The additional headers are
         * added by CloudFront.
         */
        var headerBehavior: OriginRequestPolicyHeaderBehavior?
        /**
         * Contains a list of HTTP header names.
         */
        var headers: Headers?

        fun build(): OriginRequestPolicyHeadersConfig
        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.Headers] inside the given [block]
         */
        fun headers(block: Headers.DslBuilder.() -> kotlin.Unit) {
            this.headers = Headers.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var headerBehavior: OriginRequestPolicyHeaderBehavior? = null
        override var headers: Headers? = null

        constructor(x: OriginRequestPolicyHeadersConfig) : this() {
            this.headerBehavior = x.headerBehavior
            this.headers = x.headers
        }

        override fun build(): OriginRequestPolicyHeadersConfig = OriginRequestPolicyHeadersConfig(this)
        override fun headerBehavior(headerBehavior: OriginRequestPolicyHeaderBehavior): FluentBuilder = apply { this.headerBehavior = headerBehavior }
        override fun headers(headers: Headers): FluentBuilder = apply { this.headers = headers }
    }
}
