// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model



/**
 * An object that determines whether any cookies in viewer requests (and if so, which cookies)
 * are included in requests that CloudFront sends to the origin.
 */
class OriginRequestPolicyCookiesConfig private constructor(builder: BuilderImpl) {
    /**
     * Determines whether cookies in viewer requests are included in requests that CloudFront sends to
     * the origin. Valid values are:
     * none – Cookies in viewer requests are not included in requests that CloudFront
     * sends to the origin. Even when this field is set to none, any
     * cookies that are listed in a CachePolicy
     * are
     * included in origin requests.
     * whitelist – The cookies in viewer requests that are listed in the
     * CookieNames type are included in requests that CloudFront sends to the
     * origin.
     * all – All cookies in viewer requests are included in requests that CloudFront sends
     * to the origin.
     */
    val cookieBehavior: OriginRequestPolicyCookieBehavior? = builder.cookieBehavior
    /**
     * Contains a list of cookie names.
     */
    val cookies: CookieNames? = builder.cookies

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): OriginRequestPolicyCookiesConfig = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("OriginRequestPolicyCookiesConfig(")
        append("cookieBehavior=$cookieBehavior,")
        append("cookies=$cookies)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cookieBehavior?.hashCode() ?: 0
        result = 31 * result + (cookies?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as OriginRequestPolicyCookiesConfig

        if (cookieBehavior != other.cookieBehavior) return false
        if (cookies != other.cookies) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): OriginRequestPolicyCookiesConfig = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): OriginRequestPolicyCookiesConfig
        /**
         * Determines whether cookies in viewer requests are included in requests that CloudFront sends to
         * the origin. Valid values are:
         * none – Cookies in viewer requests are not included in requests that CloudFront
         * sends to the origin. Even when this field is set to none, any
         * cookies that are listed in a CachePolicy
         * are
         * included in origin requests.
         * whitelist – The cookies in viewer requests that are listed in the
         * CookieNames type are included in requests that CloudFront sends to the
         * origin.
         * all – All cookies in viewer requests are included in requests that CloudFront sends
         * to the origin.
         */
        fun cookieBehavior(cookieBehavior: OriginRequestPolicyCookieBehavior): FluentBuilder
        /**
         * Contains a list of cookie names.
         */
        fun cookies(cookies: CookieNames): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Determines whether cookies in viewer requests are included in requests that CloudFront sends to
         * the origin. Valid values are:
         * none – Cookies in viewer requests are not included in requests that CloudFront
         * sends to the origin. Even when this field is set to none, any
         * cookies that are listed in a CachePolicy
         * are
         * included in origin requests.
         * whitelist – The cookies in viewer requests that are listed in the
         * CookieNames type are included in requests that CloudFront sends to the
         * origin.
         * all – All cookies in viewer requests are included in requests that CloudFront sends
         * to the origin.
         */
        var cookieBehavior: OriginRequestPolicyCookieBehavior?
        /**
         * Contains a list of cookie names.
         */
        var cookies: CookieNames?

        fun build(): OriginRequestPolicyCookiesConfig
        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.CookieNames] inside the given [block]
         */
        fun cookies(block: CookieNames.DslBuilder.() -> kotlin.Unit) {
            this.cookies = CookieNames.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var cookieBehavior: OriginRequestPolicyCookieBehavior? = null
        override var cookies: CookieNames? = null

        constructor(x: OriginRequestPolicyCookiesConfig) : this() {
            this.cookieBehavior = x.cookieBehavior
            this.cookies = x.cookies
        }

        override fun build(): OriginRequestPolicyCookiesConfig = OriginRequestPolicyCookiesConfig(this)
        override fun cookieBehavior(cookieBehavior: OriginRequestPolicyCookieBehavior): FluentBuilder = apply { this.cookieBehavior = cookieBehavior }
        override fun cookies(cookies: CookieNames): FluentBuilder = apply { this.cookies = cookies }
    }
}
