// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model



/**
 * An origin request policy configuration.
 * This configuration determines the values that CloudFront includes in requests that it sends to the
 * origin. Each request that CloudFront sends to the origin includes the following:
 * The request body and the URL path (without the domain name) from the viewer
 * request.
 * The headers that CloudFront automatically includes in every origin request, including
 * Host, User-Agent, and X-Amz-Cf-Id.
 * All HTTP headers, cookies, and URL query strings that are specified in the
 * cache policy or the origin request policy. These can include items from the
 * viewer request and, in the case of headers, additional ones that are added by
 * CloudFront.
 * CloudFront sends a request when it can’t find an object in its cache that matches the request. If
 * you want to send values to the origin and also include them in the cache key, use
 * CachePolicy.
 */
class OriginRequestPolicyConfig private constructor(builder: BuilderImpl) {
    /**
     * A comment to describe the origin request policy. The comment cannot be longer than 128
     * characters.
     */
    val comment: String? = builder.comment
    /**
     * The cookies from viewer requests to include in origin requests.
     */
    val cookiesConfig: OriginRequestPolicyCookiesConfig? = builder.cookiesConfig
    /**
     * The HTTP headers to include in origin requests. These can include headers from viewer
     * requests and additional headers added by CloudFront.
     */
    val headersConfig: OriginRequestPolicyHeadersConfig? = builder.headersConfig
    /**
     * A unique name to identify the origin request policy.
     */
    val name: String? = builder.name
    /**
     * The URL query strings from viewer requests to include in origin requests.
     */
    val queryStringsConfig: OriginRequestPolicyQueryStringsConfig? = builder.queryStringsConfig

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): OriginRequestPolicyConfig = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("OriginRequestPolicyConfig(")
        append("comment=$comment,")
        append("cookiesConfig=$cookiesConfig,")
        append("headersConfig=$headersConfig,")
        append("name=$name,")
        append("queryStringsConfig=$queryStringsConfig)")
    }

    override fun hashCode(): kotlin.Int {
        var result = comment?.hashCode() ?: 0
        result = 31 * result + (cookiesConfig?.hashCode() ?: 0)
        result = 31 * result + (headersConfig?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (queryStringsConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as OriginRequestPolicyConfig

        if (comment != other.comment) return false
        if (cookiesConfig != other.cookiesConfig) return false
        if (headersConfig != other.headersConfig) return false
        if (name != other.name) return false
        if (queryStringsConfig != other.queryStringsConfig) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): OriginRequestPolicyConfig = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): OriginRequestPolicyConfig
        /**
         * A comment to describe the origin request policy. The comment cannot be longer than 128
         * characters.
         */
        fun comment(comment: String): FluentBuilder
        /**
         * The cookies from viewer requests to include in origin requests.
         */
        fun cookiesConfig(cookiesConfig: OriginRequestPolicyCookiesConfig): FluentBuilder
        /**
         * The HTTP headers to include in origin requests. These can include headers from viewer
         * requests and additional headers added by CloudFront.
         */
        fun headersConfig(headersConfig: OriginRequestPolicyHeadersConfig): FluentBuilder
        /**
         * A unique name to identify the origin request policy.
         */
        fun name(name: String): FluentBuilder
        /**
         * The URL query strings from viewer requests to include in origin requests.
         */
        fun queryStringsConfig(queryStringsConfig: OriginRequestPolicyQueryStringsConfig): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A comment to describe the origin request policy. The comment cannot be longer than 128
         * characters.
         */
        var comment: String?
        /**
         * The cookies from viewer requests to include in origin requests.
         */
        var cookiesConfig: OriginRequestPolicyCookiesConfig?
        /**
         * The HTTP headers to include in origin requests. These can include headers from viewer
         * requests and additional headers added by CloudFront.
         */
        var headersConfig: OriginRequestPolicyHeadersConfig?
        /**
         * A unique name to identify the origin request policy.
         */
        var name: String?
        /**
         * The URL query strings from viewer requests to include in origin requests.
         */
        var queryStringsConfig: OriginRequestPolicyQueryStringsConfig?

        fun build(): OriginRequestPolicyConfig
        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.OriginRequestPolicyCookiesConfig] inside the given [block]
         */
        fun cookiesConfig(block: OriginRequestPolicyCookiesConfig.DslBuilder.() -> kotlin.Unit) {
            this.cookiesConfig = OriginRequestPolicyCookiesConfig.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.OriginRequestPolicyHeadersConfig] inside the given [block]
         */
        fun headersConfig(block: OriginRequestPolicyHeadersConfig.DslBuilder.() -> kotlin.Unit) {
            this.headersConfig = OriginRequestPolicyHeadersConfig.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.OriginRequestPolicyQueryStringsConfig] inside the given [block]
         */
        fun queryStringsConfig(block: OriginRequestPolicyQueryStringsConfig.DslBuilder.() -> kotlin.Unit) {
            this.queryStringsConfig = OriginRequestPolicyQueryStringsConfig.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var comment: String? = null
        override var cookiesConfig: OriginRequestPolicyCookiesConfig? = null
        override var headersConfig: OriginRequestPolicyHeadersConfig? = null
        override var name: String? = null
        override var queryStringsConfig: OriginRequestPolicyQueryStringsConfig? = null

        constructor(x: OriginRequestPolicyConfig) : this() {
            this.comment = x.comment
            this.cookiesConfig = x.cookiesConfig
            this.headersConfig = x.headersConfig
            this.name = x.name
            this.queryStringsConfig = x.queryStringsConfig
        }

        override fun build(): OriginRequestPolicyConfig = OriginRequestPolicyConfig(this)
        override fun comment(comment: String): FluentBuilder = apply { this.comment = comment }
        override fun cookiesConfig(cookiesConfig: OriginRequestPolicyCookiesConfig): FluentBuilder = apply { this.cookiesConfig = cookiesConfig }
        override fun headersConfig(headersConfig: OriginRequestPolicyHeadersConfig): FluentBuilder = apply { this.headersConfig = headersConfig }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun queryStringsConfig(queryStringsConfig: OriginRequestPolicyQueryStringsConfig): FluentBuilder = apply { this.queryStringsConfig = queryStringsConfig }
    }
}
