// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * An origin request policy.
 * When it’s attached to a cache behavior, the origin request policy determines the values that
 * CloudFront includes in requests that it sends to the origin. Each request that CloudFront sends to
 * the origin includes the following:
 * The request body and the URL path (without the domain name) from the viewer
 * request.
 * The headers that CloudFront automatically includes in every origin request, including
 * Host, User-Agent, and X-Amz-Cf-Id.
 * All HTTP headers, cookies, and URL query strings that are specified in the
 * cache policy or the origin request policy. These can include items from the
 * viewer request and, in the case of headers, additional ones that are added by
 * CloudFront.
 * CloudFront sends a request when it can’t find an object in its cache that matches the request. If
 * you want to send values to the origin and also include them in the cache key, use
 * CachePolicy.
 */
class OriginRequestPolicy private constructor(builder: BuilderImpl) {
    /**
     * The unique identifier for the origin request policy.
     */
    val id: String? = builder.id
    /**
     * The date and time when the origin request policy was last modified.
     */
    val lastModifiedTime: Instant? = builder.lastModifiedTime
    /**
     * The origin request policy configuration.
     */
    val originRequestPolicyConfig: OriginRequestPolicyConfig? = builder.originRequestPolicyConfig

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): OriginRequestPolicy = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("OriginRequestPolicy(")
        append("id=$id,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("originRequestPolicyConfig=$originRequestPolicyConfig)")
    }

    override fun hashCode(): kotlin.Int {
        var result = id?.hashCode() ?: 0
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (originRequestPolicyConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as OriginRequestPolicy

        if (id != other.id) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (originRequestPolicyConfig != other.originRequestPolicyConfig) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): OriginRequestPolicy = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): OriginRequestPolicy
        /**
         * The unique identifier for the origin request policy.
         */
        fun id(id: String): FluentBuilder
        /**
         * The date and time when the origin request policy was last modified.
         */
        fun lastModifiedTime(lastModifiedTime: Instant): FluentBuilder
        /**
         * The origin request policy configuration.
         */
        fun originRequestPolicyConfig(originRequestPolicyConfig: OriginRequestPolicyConfig): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The unique identifier for the origin request policy.
         */
        var id: String?
        /**
         * The date and time when the origin request policy was last modified.
         */
        var lastModifiedTime: Instant?
        /**
         * The origin request policy configuration.
         */
        var originRequestPolicyConfig: OriginRequestPolicyConfig?

        fun build(): OriginRequestPolicy
        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.OriginRequestPolicyConfig] inside the given [block]
         */
        fun originRequestPolicyConfig(block: OriginRequestPolicyConfig.DslBuilder.() -> kotlin.Unit) {
            this.originRequestPolicyConfig = OriginRequestPolicyConfig.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var id: String? = null
        override var lastModifiedTime: Instant? = null
        override var originRequestPolicyConfig: OriginRequestPolicyConfig? = null

        constructor(x: OriginRequestPolicy) : this() {
            this.id = x.id
            this.lastModifiedTime = x.lastModifiedTime
            this.originRequestPolicyConfig = x.originRequestPolicyConfig
        }

        override fun build(): OriginRequestPolicy = OriginRequestPolicy(this)
        override fun id(id: String): FluentBuilder = apply { this.id = id }
        override fun lastModifiedTime(lastModifiedTime: Instant): FluentBuilder = apply { this.lastModifiedTime = lastModifiedTime }
        override fun originRequestPolicyConfig(originRequestPolicyConfig: OriginRequestPolicyConfig): FluentBuilder = apply { this.originRequestPolicyConfig = originRequestPolicyConfig }
    }
}
