// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model



/**
 * An origin group includes two origins (a primary origin and a second origin to failover to) and a failover criteria that you specify.
 * You create an origin group to support origin failover in CloudFront. When you create or update a distribution, you can specifiy
 * the origin group instead of a single origin, and CloudFront will failover from the primary origin to the second origin
 * under the failover conditions that you've chosen.
 */
class OriginGroup private constructor(builder: BuilderImpl) {
    /**
     * A complex type that contains information about the failover criteria for an origin group.
     */
    val failoverCriteria: OriginGroupFailoverCriteria? = builder.failoverCriteria
    /**
     * The origin group's ID.
     */
    val id: String? = builder.id
    /**
     * A complex type that contains information about the origins in an origin group.
     */
    val members: OriginGroupMembers? = builder.members

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): OriginGroup = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("OriginGroup(")
        append("failoverCriteria=$failoverCriteria,")
        append("id=$id,")
        append("members=$members)")
    }

    override fun hashCode(): kotlin.Int {
        var result = failoverCriteria?.hashCode() ?: 0
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (members?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as OriginGroup

        if (failoverCriteria != other.failoverCriteria) return false
        if (id != other.id) return false
        if (members != other.members) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): OriginGroup = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): OriginGroup
        /**
         * A complex type that contains information about the failover criteria for an origin group.
         */
        fun failoverCriteria(failoverCriteria: OriginGroupFailoverCriteria): FluentBuilder
        /**
         * The origin group's ID.
         */
        fun id(id: String): FluentBuilder
        /**
         * A complex type that contains information about the origins in an origin group.
         */
        fun members(members: OriginGroupMembers): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A complex type that contains information about the failover criteria for an origin group.
         */
        var failoverCriteria: OriginGroupFailoverCriteria?
        /**
         * The origin group's ID.
         */
        var id: String?
        /**
         * A complex type that contains information about the origins in an origin group.
         */
        var members: OriginGroupMembers?

        fun build(): OriginGroup
        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.OriginGroupFailoverCriteria] inside the given [block]
         */
        fun failoverCriteria(block: OriginGroupFailoverCriteria.DslBuilder.() -> kotlin.Unit) {
            this.failoverCriteria = OriginGroupFailoverCriteria.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.OriginGroupMembers] inside the given [block]
         */
        fun members(block: OriginGroupMembers.DslBuilder.() -> kotlin.Unit) {
            this.members = OriginGroupMembers.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var failoverCriteria: OriginGroupFailoverCriteria? = null
        override var id: String? = null
        override var members: OriginGroupMembers? = null

        constructor(x: OriginGroup) : this() {
            this.failoverCriteria = x.failoverCriteria
            this.id = x.id
            this.members = x.members
        }

        override fun build(): OriginGroup = OriginGroup(this)
        override fun failoverCriteria(failoverCriteria: OriginGroupFailoverCriteria): FluentBuilder = apply { this.failoverCriteria = failoverCriteria }
        override fun id(id: String): FluentBuilder = apply { this.id = id }
        override fun members(members: OriginGroupMembers): FluentBuilder = apply { this.members = members }
    }
}
