// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model



/**
 * An origin.
 * An origin is the location where content is stored, and from which CloudFront gets content to
 * serve to viewers. To specify an origin:
 * Use S3OriginConfig to specify an Amazon S3 bucket that is not
 * configured with static website hosting.
 * Use CustomOriginConfig to specify all other kinds of origins,
 * including:
 * An Amazon S3 bucket that is configured with static website hosting
 * An Elastic Load Balancing load balancer
 * An AWS Elemental MediaPackage endpoint
 * An AWS Elemental MediaStore container
 * Any other HTTP server, running on an Amazon EC2 instance or any other
 * kind of host
 * For the current maximum number of origins that you can specify per distribution, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html#limits-web-distributions">General Quotas on Web Distributions in the Amazon CloudFront Developer Guide
 * (quotas were formerly referred to as limits).
 */
class Origin private constructor(builder: BuilderImpl) {
    /**
     * The number of times that CloudFront attempts to connect to the origin. The minimum number
     * is 1, the maximum is 3, and the default (if you don’t specify otherwise) is 3.
     * For a custom origin (including an Amazon S3 bucket that’s configured with static
     * website hosting), this value also specifies the number of times that CloudFront attempts to
     * get a response from the origin, in the case of an <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginResponseTimeout">Origin Response Timeout.
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#origin-connection-attempts">Origin Connection Attempts in the
     * Amazon CloudFront Developer Guide.
     */
    val connectionAttempts: Int? = builder.connectionAttempts
    /**
     * The number of seconds that CloudFront waits when trying to establish a connection to the origin.
     * The minimum timeout is 1 second, the maximum is 10 seconds, and the default (if you
     * don’t specify otherwise) is 10 seconds.
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#origin-connection-timeout">Origin Connection Timeout in the
     * Amazon CloudFront Developer Guide.
     */
    val connectionTimeout: Int? = builder.connectionTimeout
    /**
     * A list of HTTP header names and values that CloudFront adds to the requests that it sends to
     * the origin.
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/add-origin-custom-headers.html">Adding Custom Headers to Origin Requests in the
     * Amazon CloudFront Developer Guide.
     */
    val customHeaders: CustomHeaders? = builder.customHeaders
    /**
     * Use this type to specify an origin that is not an Amazon S3 bucket, with one exception. If the
     * Amazon S3 bucket is configured with static website hosting, use this type. If the Amazon S3 bucket
     * is not configured with static website hosting, use the S3OriginConfig type
     * instead.
     */
    val customOriginConfig: CustomOriginConfig? = builder.customOriginConfig
    /**
     * The domain name for the origin.
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesDomainName">Origin Domain Name in the Amazon CloudFront Developer Guide.
     */
    val domainName: String? = builder.domainName
    /**
     * A unique identifier for the origin. This value must be unique within the
     * distribution.
     * Use this value to specify the TargetOriginId in a
     * CacheBehavior or DefaultCacheBehavior.
     */
    val id: String? = builder.id
    /**
     * An optional path that CloudFront appends to the origin domain name when CloudFront requests content from
     * the origin.
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginPath">Origin Path in the
     * Amazon CloudFront Developer Guide.
     */
    val originPath: String? = builder.originPath
    /**
     * CloudFront Origin Shield. Using Origin Shield can help reduce the load on your
     * origin.
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/origin-shield.html">Using Origin Shield in the Amazon CloudFront Developer Guide.
     */
    val originShield: OriginShield? = builder.originShield
    /**
     * Use this type to specify an origin that is an Amazon S3 bucket that is not configured with static
     * website hosting. To specify any other type of origin, including an Amazon S3 bucket that is
     * configured with static website hosting, use the CustomOriginConfig type
     * instead.
     */
    val s3OriginConfig: S3OriginConfig? = builder.s3OriginConfig

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Origin = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Origin(")
        append("connectionAttempts=$connectionAttempts,")
        append("connectionTimeout=$connectionTimeout,")
        append("customHeaders=$customHeaders,")
        append("customOriginConfig=$customOriginConfig,")
        append("domainName=$domainName,")
        append("id=$id,")
        append("originPath=$originPath,")
        append("originShield=$originShield,")
        append("s3OriginConfig=$s3OriginConfig)")
    }

    override fun hashCode(): kotlin.Int {
        var result = connectionAttempts ?: 0
        result = 31 * result + (connectionTimeout ?: 0)
        result = 31 * result + (customHeaders?.hashCode() ?: 0)
        result = 31 * result + (customOriginConfig?.hashCode() ?: 0)
        result = 31 * result + (domainName?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (originPath?.hashCode() ?: 0)
        result = 31 * result + (originShield?.hashCode() ?: 0)
        result = 31 * result + (s3OriginConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Origin

        if (connectionAttempts != other.connectionAttempts) return false
        if (connectionTimeout != other.connectionTimeout) return false
        if (customHeaders != other.customHeaders) return false
        if (customOriginConfig != other.customOriginConfig) return false
        if (domainName != other.domainName) return false
        if (id != other.id) return false
        if (originPath != other.originPath) return false
        if (originShield != other.originShield) return false
        if (s3OriginConfig != other.s3OriginConfig) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Origin = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Origin
        /**
         * The number of times that CloudFront attempts to connect to the origin. The minimum number
         * is 1, the maximum is 3, and the default (if you don’t specify otherwise) is 3.
         * For a custom origin (including an Amazon S3 bucket that’s configured with static
         * website hosting), this value also specifies the number of times that CloudFront attempts to
         * get a response from the origin, in the case of an <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginResponseTimeout">Origin Response Timeout.
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#origin-connection-attempts">Origin Connection Attempts in the
         * Amazon CloudFront Developer Guide.
         */
        fun connectionAttempts(connectionAttempts: Int): FluentBuilder
        /**
         * The number of seconds that CloudFront waits when trying to establish a connection to the origin.
         * The minimum timeout is 1 second, the maximum is 10 seconds, and the default (if you
         * don’t specify otherwise) is 10 seconds.
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#origin-connection-timeout">Origin Connection Timeout in the
         * Amazon CloudFront Developer Guide.
         */
        fun connectionTimeout(connectionTimeout: Int): FluentBuilder
        /**
         * A list of HTTP header names and values that CloudFront adds to the requests that it sends to
         * the origin.
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/add-origin-custom-headers.html">Adding Custom Headers to Origin Requests in the
         * Amazon CloudFront Developer Guide.
         */
        fun customHeaders(customHeaders: CustomHeaders): FluentBuilder
        /**
         * Use this type to specify an origin that is not an Amazon S3 bucket, with one exception. If the
         * Amazon S3 bucket is configured with static website hosting, use this type. If the Amazon S3 bucket
         * is not configured with static website hosting, use the S3OriginConfig type
         * instead.
         */
        fun customOriginConfig(customOriginConfig: CustomOriginConfig): FluentBuilder
        /**
         * The domain name for the origin.
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesDomainName">Origin Domain Name in the Amazon CloudFront Developer Guide.
         */
        fun domainName(domainName: String): FluentBuilder
        /**
         * A unique identifier for the origin. This value must be unique within the
         * distribution.
         * Use this value to specify the TargetOriginId in a
         * CacheBehavior or DefaultCacheBehavior.
         */
        fun id(id: String): FluentBuilder
        /**
         * An optional path that CloudFront appends to the origin domain name when CloudFront requests content from
         * the origin.
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginPath">Origin Path in the
         * Amazon CloudFront Developer Guide.
         */
        fun originPath(originPath: String): FluentBuilder
        /**
         * CloudFront Origin Shield. Using Origin Shield can help reduce the load on your
         * origin.
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/origin-shield.html">Using Origin Shield in the Amazon CloudFront Developer Guide.
         */
        fun originShield(originShield: OriginShield): FluentBuilder
        /**
         * Use this type to specify an origin that is an Amazon S3 bucket that is not configured with static
         * website hosting. To specify any other type of origin, including an Amazon S3 bucket that is
         * configured with static website hosting, use the CustomOriginConfig type
         * instead.
         */
        fun s3OriginConfig(s3OriginConfig: S3OriginConfig): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The number of times that CloudFront attempts to connect to the origin. The minimum number
         * is 1, the maximum is 3, and the default (if you don’t specify otherwise) is 3.
         * For a custom origin (including an Amazon S3 bucket that’s configured with static
         * website hosting), this value also specifies the number of times that CloudFront attempts to
         * get a response from the origin, in the case of an <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginResponseTimeout">Origin Response Timeout.
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#origin-connection-attempts">Origin Connection Attempts in the
         * Amazon CloudFront Developer Guide.
         */
        var connectionAttempts: Int?
        /**
         * The number of seconds that CloudFront waits when trying to establish a connection to the origin.
         * The minimum timeout is 1 second, the maximum is 10 seconds, and the default (if you
         * don’t specify otherwise) is 10 seconds.
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#origin-connection-timeout">Origin Connection Timeout in the
         * Amazon CloudFront Developer Guide.
         */
        var connectionTimeout: Int?
        /**
         * A list of HTTP header names and values that CloudFront adds to the requests that it sends to
         * the origin.
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/add-origin-custom-headers.html">Adding Custom Headers to Origin Requests in the
         * Amazon CloudFront Developer Guide.
         */
        var customHeaders: CustomHeaders?
        /**
         * Use this type to specify an origin that is not an Amazon S3 bucket, with one exception. If the
         * Amazon S3 bucket is configured with static website hosting, use this type. If the Amazon S3 bucket
         * is not configured with static website hosting, use the S3OriginConfig type
         * instead.
         */
        var customOriginConfig: CustomOriginConfig?
        /**
         * The domain name for the origin.
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesDomainName">Origin Domain Name in the Amazon CloudFront Developer Guide.
         */
        var domainName: String?
        /**
         * A unique identifier for the origin. This value must be unique within the
         * distribution.
         * Use this value to specify the TargetOriginId in a
         * CacheBehavior or DefaultCacheBehavior.
         */
        var id: String?
        /**
         * An optional path that CloudFront appends to the origin domain name when CloudFront requests content from
         * the origin.
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginPath">Origin Path in the
         * Amazon CloudFront Developer Guide.
         */
        var originPath: String?
        /**
         * CloudFront Origin Shield. Using Origin Shield can help reduce the load on your
         * origin.
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/origin-shield.html">Using Origin Shield in the Amazon CloudFront Developer Guide.
         */
        var originShield: OriginShield?
        /**
         * Use this type to specify an origin that is an Amazon S3 bucket that is not configured with static
         * website hosting. To specify any other type of origin, including an Amazon S3 bucket that is
         * configured with static website hosting, use the CustomOriginConfig type
         * instead.
         */
        var s3OriginConfig: S3OriginConfig?

        fun build(): Origin
        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.CustomHeaders] inside the given [block]
         */
        fun customHeaders(block: CustomHeaders.DslBuilder.() -> kotlin.Unit) {
            this.customHeaders = CustomHeaders.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.CustomOriginConfig] inside the given [block]
         */
        fun customOriginConfig(block: CustomOriginConfig.DslBuilder.() -> kotlin.Unit) {
            this.customOriginConfig = CustomOriginConfig.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.OriginShield] inside the given [block]
         */
        fun originShield(block: OriginShield.DslBuilder.() -> kotlin.Unit) {
            this.originShield = OriginShield.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.S3OriginConfig] inside the given [block]
         */
        fun s3OriginConfig(block: S3OriginConfig.DslBuilder.() -> kotlin.Unit) {
            this.s3OriginConfig = S3OriginConfig.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var connectionAttempts: Int? = null
        override var connectionTimeout: Int? = null
        override var customHeaders: CustomHeaders? = null
        override var customOriginConfig: CustomOriginConfig? = null
        override var domainName: String? = null
        override var id: String? = null
        override var originPath: String? = null
        override var originShield: OriginShield? = null
        override var s3OriginConfig: S3OriginConfig? = null

        constructor(x: Origin) : this() {
            this.connectionAttempts = x.connectionAttempts
            this.connectionTimeout = x.connectionTimeout
            this.customHeaders = x.customHeaders
            this.customOriginConfig = x.customOriginConfig
            this.domainName = x.domainName
            this.id = x.id
            this.originPath = x.originPath
            this.originShield = x.originShield
            this.s3OriginConfig = x.s3OriginConfig
        }

        override fun build(): Origin = Origin(this)
        override fun connectionAttempts(connectionAttempts: Int): FluentBuilder = apply { this.connectionAttempts = connectionAttempts }
        override fun connectionTimeout(connectionTimeout: Int): FluentBuilder = apply { this.connectionTimeout = connectionTimeout }
        override fun customHeaders(customHeaders: CustomHeaders): FluentBuilder = apply { this.customHeaders = customHeaders }
        override fun customOriginConfig(customOriginConfig: CustomOriginConfig): FluentBuilder = apply { this.customOriginConfig = customOriginConfig }
        override fun domainName(domainName: String): FluentBuilder = apply { this.domainName = domainName }
        override fun id(id: String): FluentBuilder = apply { this.id = id }
        override fun originPath(originPath: String): FluentBuilder = apply { this.originPath = originPath }
        override fun originShield(originShield: OriginShield): FluentBuilder = apply { this.originShield = originShield }
        override fun s3OriginConfig(s3OriginConfig: S3OriginConfig): FluentBuilder = apply { this.s3OriginConfig = s3OriginConfig }
    }
}
