// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model



/**
 * A complex type that controls whether access logs are written for the
 * distribution.
 */
class LoggingConfig private constructor(builder: BuilderImpl) {
    /**
     * The Amazon S3 bucket to store the access logs in, for example,
     * myawslogbucket.s3.amazonaws.com.
     */
    val bucket: String? = builder.bucket
    /**
     * Specifies whether you want CloudFront to save access logs to an Amazon S3 bucket. If you don't
     * want to enable logging when you create a distribution or if you want to disable logging for an
     * existing distribution, specify false for Enabled, and specify empty
     * Bucket and Prefix elements. If you specify false for
     * Enabled but you specify values for Bucket, prefix,
     * and IncludeCookies, the values are automatically deleted.
     */
    val enabled: Boolean? = builder.enabled
    /**
     * Specifies whether you want CloudFront to include cookies in access logs, specify
     * true for IncludeCookies. If you choose to include cookies in logs,
     * CloudFront logs all cookies regardless of how you configure the cache behaviors for this
     * distribution. If you don't want to include cookies when you create a distribution or if you
     * want to disable include cookies for an existing distribution, specify false for
     * IncludeCookies.
     */
    val includeCookies: Boolean? = builder.includeCookies
    /**
     * An optional string that you want CloudFront to prefix to the access log
     * filenames for this distribution, for example, myprefix/. If you
     * want to enable logging, but you don't want to specify a prefix, you still must include an
     * empty Prefix element in the Logging element.
     */
    val prefix: String? = builder.prefix

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): LoggingConfig = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("LoggingConfig(")
        append("bucket=$bucket,")
        append("enabled=$enabled,")
        append("includeCookies=$includeCookies,")
        append("prefix=$prefix)")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucket?.hashCode() ?: 0
        result = 31 * result + (enabled?.hashCode() ?: 0)
        result = 31 * result + (includeCookies?.hashCode() ?: 0)
        result = 31 * result + (prefix?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as LoggingConfig

        if (bucket != other.bucket) return false
        if (enabled != other.enabled) return false
        if (includeCookies != other.includeCookies) return false
        if (prefix != other.prefix) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): LoggingConfig = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): LoggingConfig
        /**
         * The Amazon S3 bucket to store the access logs in, for example,
         * myawslogbucket.s3.amazonaws.com.
         */
        fun bucket(bucket: String): FluentBuilder
        /**
         * Specifies whether you want CloudFront to save access logs to an Amazon S3 bucket. If you don't
         * want to enable logging when you create a distribution or if you want to disable logging for an
         * existing distribution, specify false for Enabled, and specify empty
         * Bucket and Prefix elements. If you specify false for
         * Enabled but you specify values for Bucket, prefix,
         * and IncludeCookies, the values are automatically deleted.
         */
        fun enabled(enabled: Boolean): FluentBuilder
        /**
         * Specifies whether you want CloudFront to include cookies in access logs, specify
         * true for IncludeCookies. If you choose to include cookies in logs,
         * CloudFront logs all cookies regardless of how you configure the cache behaviors for this
         * distribution. If you don't want to include cookies when you create a distribution or if you
         * want to disable include cookies for an existing distribution, specify false for
         * IncludeCookies.
         */
        fun includeCookies(includeCookies: Boolean): FluentBuilder
        /**
         * An optional string that you want CloudFront to prefix to the access log
         * filenames for this distribution, for example, myprefix/. If you
         * want to enable logging, but you don't want to specify a prefix, you still must include an
         * empty Prefix element in the Logging element.
         */
        fun prefix(prefix: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon S3 bucket to store the access logs in, for example,
         * myawslogbucket.s3.amazonaws.com.
         */
        var bucket: String?
        /**
         * Specifies whether you want CloudFront to save access logs to an Amazon S3 bucket. If you don't
         * want to enable logging when you create a distribution or if you want to disable logging for an
         * existing distribution, specify false for Enabled, and specify empty
         * Bucket and Prefix elements. If you specify false for
         * Enabled but you specify values for Bucket, prefix,
         * and IncludeCookies, the values are automatically deleted.
         */
        var enabled: Boolean?
        /**
         * Specifies whether you want CloudFront to include cookies in access logs, specify
         * true for IncludeCookies. If you choose to include cookies in logs,
         * CloudFront logs all cookies regardless of how you configure the cache behaviors for this
         * distribution. If you don't want to include cookies when you create a distribution or if you
         * want to disable include cookies for an existing distribution, specify false for
         * IncludeCookies.
         */
        var includeCookies: Boolean?
        /**
         * An optional string that you want CloudFront to prefix to the access log
         * filenames for this distribution, for example, myprefix/. If you
         * want to enable logging, but you don't want to specify a prefix, you still must include an
         * empty Prefix element in the Logging element.
         */
        var prefix: String?

        fun build(): LoggingConfig
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var bucket: String? = null
        override var enabled: Boolean? = null
        override var includeCookies: Boolean? = null
        override var prefix: String? = null

        constructor(x: LoggingConfig) : this() {
            this.bucket = x.bucket
            this.enabled = x.enabled
            this.includeCookies = x.includeCookies
            this.prefix = x.prefix
        }

        override fun build(): LoggingConfig = LoggingConfig(this)
        override fun bucket(bucket: String): FluentBuilder = apply { this.bucket = bucket }
        override fun enabled(enabled: Boolean): FluentBuilder = apply { this.enabled = enabled }
        override fun includeCookies(includeCookies: Boolean): FluentBuilder = apply { this.includeCookies = includeCookies }
        override fun prefix(prefix: String): FluentBuilder = apply { this.prefix = prefix }
    }
}
