// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model



/**
 * The request to list invalidations.
 */
class ListInvalidationsRequest private constructor(builder: BuilderImpl) {
    /**
     * The distribution's ID.
     */
    val distributionId: String? = builder.distributionId
    /**
     * Use this parameter when paginating results to indicate where to begin in your list of
     * invalidation batches. Because the results are returned in decreasing order from most recent to
     * oldest, the most recent results are on the first page, the second page will contain earlier
     * results, and so on. To get the next page of results, set Marker to the value of
     * the NextMarker from the current page's response. This value is the same as the ID
     * of the last invalidation batch on that page.
     */
    val marker: String? = builder.marker
    /**
     * The maximum number of invalidation batches that you want in the response
     * body.
     */
    val maxItems: Int? = builder.maxItems

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ListInvalidationsRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ListInvalidationsRequest(")
        append("distributionId=$distributionId,")
        append("marker=$marker,")
        append("maxItems=$maxItems)")
    }

    override fun hashCode(): kotlin.Int {
        var result = distributionId?.hashCode() ?: 0
        result = 31 * result + (marker?.hashCode() ?: 0)
        result = 31 * result + (maxItems ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ListInvalidationsRequest

        if (distributionId != other.distributionId) return false
        if (marker != other.marker) return false
        if (maxItems != other.maxItems) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ListInvalidationsRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ListInvalidationsRequest
        /**
         * The distribution's ID.
         */
        fun distributionId(distributionId: String): FluentBuilder
        /**
         * Use this parameter when paginating results to indicate where to begin in your list of
         * invalidation batches. Because the results are returned in decreasing order from most recent to
         * oldest, the most recent results are on the first page, the second page will contain earlier
         * results, and so on. To get the next page of results, set Marker to the value of
         * the NextMarker from the current page's response. This value is the same as the ID
         * of the last invalidation batch on that page.
         */
        fun marker(marker: String): FluentBuilder
        /**
         * The maximum number of invalidation batches that you want in the response
         * body.
         */
        fun maxItems(maxItems: Int): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The distribution's ID.
         */
        var distributionId: String?
        /**
         * Use this parameter when paginating results to indicate where to begin in your list of
         * invalidation batches. Because the results are returned in decreasing order from most recent to
         * oldest, the most recent results are on the first page, the second page will contain earlier
         * results, and so on. To get the next page of results, set Marker to the value of
         * the NextMarker from the current page's response. This value is the same as the ID
         * of the last invalidation batch on that page.
         */
        var marker: String?
        /**
         * The maximum number of invalidation batches that you want in the response
         * body.
         */
        var maxItems: Int?

        fun build(): ListInvalidationsRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var distributionId: String? = null
        override var marker: String? = null
        override var maxItems: Int? = null

        constructor(x: ListInvalidationsRequest) : this() {
            this.distributionId = x.distributionId
            this.marker = x.marker
            this.maxItems = x.maxItems
        }

        override fun build(): ListInvalidationsRequest = ListInvalidationsRequest(this)
        override fun distributionId(distributionId: String): FluentBuilder = apply { this.distributionId = distributionId }
        override fun marker(marker: String): FluentBuilder = apply { this.marker = marker }
        override fun maxItems(maxItems: Int): FluentBuilder = apply { this.maxItems = maxItems }
    }
}
