// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model



/**
 * The request to list distributions that are associated with a specified WAF web
 * ACL.
 */
class ListDistributionsByWebAclIdRequest private constructor(builder: BuilderImpl) {
    /**
     * Use Marker and MaxItems to control pagination of results. If
     * you have more than MaxItems distributions that satisfy the request, the response
     * includes a NextMarker element. To get the next page of results, submit another
     * request. For the value of Marker, specify the value of NextMarker
     * from the last response. (For the first request, omit Marker.)
     */
    val marker: String? = builder.marker
    /**
     * The maximum number of distributions that you want CloudFront to return in the response body.
     * The maximum and default values are both 100.
     */
    val maxItems: Int? = builder.maxItems
    /**
     * The ID of the WAF web ACL that you want to list the associated distributions.
     * If you specify "null" for the ID, the request returns a list of the distributions that aren't
     * associated with a web ACL.
     */
    val webAclId: String? = builder.webAclId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ListDistributionsByWebAclIdRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ListDistributionsByWebAclIdRequest(")
        append("marker=$marker,")
        append("maxItems=$maxItems,")
        append("webAclId=$webAclId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = marker?.hashCode() ?: 0
        result = 31 * result + (maxItems ?: 0)
        result = 31 * result + (webAclId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ListDistributionsByWebAclIdRequest

        if (marker != other.marker) return false
        if (maxItems != other.maxItems) return false
        if (webAclId != other.webAclId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ListDistributionsByWebAclIdRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ListDistributionsByWebAclIdRequest
        /**
         * Use Marker and MaxItems to control pagination of results. If
         * you have more than MaxItems distributions that satisfy the request, the response
         * includes a NextMarker element. To get the next page of results, submit another
         * request. For the value of Marker, specify the value of NextMarker
         * from the last response. (For the first request, omit Marker.)
         */
        fun marker(marker: String): FluentBuilder
        /**
         * The maximum number of distributions that you want CloudFront to return in the response body.
         * The maximum and default values are both 100.
         */
        fun maxItems(maxItems: Int): FluentBuilder
        /**
         * The ID of the WAF web ACL that you want to list the associated distributions.
         * If you specify "null" for the ID, the request returns a list of the distributions that aren't
         * associated with a web ACL.
         */
        fun webAclId(webAclId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Use Marker and MaxItems to control pagination of results. If
         * you have more than MaxItems distributions that satisfy the request, the response
         * includes a NextMarker element. To get the next page of results, submit another
         * request. For the value of Marker, specify the value of NextMarker
         * from the last response. (For the first request, omit Marker.)
         */
        var marker: String?
        /**
         * The maximum number of distributions that you want CloudFront to return in the response body.
         * The maximum and default values are both 100.
         */
        var maxItems: Int?
        /**
         * The ID of the WAF web ACL that you want to list the associated distributions.
         * If you specify "null" for the ID, the request returns a list of the distributions that aren't
         * associated with a web ACL.
         */
        var webAclId: String?

        fun build(): ListDistributionsByWebAclIdRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var marker: String? = null
        override var maxItems: Int? = null
        override var webAclId: String? = null

        constructor(x: ListDistributionsByWebAclIdRequest) : this() {
            this.marker = x.marker
            this.maxItems = x.maxItems
            this.webAclId = x.webAclId
        }

        override fun build(): ListDistributionsByWebAclIdRequest = ListDistributionsByWebAclIdRequest(this)
        override fun marker(marker: String): FluentBuilder = apply { this.marker = marker }
        override fun maxItems(maxItems: Int): FluentBuilder = apply { this.maxItems = maxItems }
        override fun webAclId(webAclId: String): FluentBuilder = apply { this.webAclId = webAclId }
    }
}
