// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model



class ListConflictingAliasesRequest private constructor(builder: BuilderImpl) {
    /**
     * The alias (also called a CNAME) to search for conflicting aliases.
     */
    val alias: String? = builder.alias
    /**
     * The ID of a distribution in your account that has an attached SSL/TLS certificate that
     * includes the provided alias.
     */
    val distributionId: String? = builder.distributionId
    /**
     * Use this field when paginating results to indicate where to begin in the list of
     * conflicting aliases. The response includes conflicting aliases in the list that occur
     * after the marker. To get the next page of the list, set this field’s value to the value
     * of NextMarker from the current page’s response.
     */
    val marker: String? = builder.marker
    /**
     * The maximum number of conflicting aliases that you want in the response.
     */
    val maxItems: Int? = builder.maxItems

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ListConflictingAliasesRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ListConflictingAliasesRequest(")
        append("alias=$alias,")
        append("distributionId=$distributionId,")
        append("marker=$marker,")
        append("maxItems=$maxItems)")
    }

    override fun hashCode(): kotlin.Int {
        var result = alias?.hashCode() ?: 0
        result = 31 * result + (distributionId?.hashCode() ?: 0)
        result = 31 * result + (marker?.hashCode() ?: 0)
        result = 31 * result + (maxItems ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ListConflictingAliasesRequest

        if (alias != other.alias) return false
        if (distributionId != other.distributionId) return false
        if (marker != other.marker) return false
        if (maxItems != other.maxItems) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ListConflictingAliasesRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ListConflictingAliasesRequest
        /**
         * The alias (also called a CNAME) to search for conflicting aliases.
         */
        fun alias(alias: String): FluentBuilder
        /**
         * The ID of a distribution in your account that has an attached SSL/TLS certificate that
         * includes the provided alias.
         */
        fun distributionId(distributionId: String): FluentBuilder
        /**
         * Use this field when paginating results to indicate where to begin in the list of
         * conflicting aliases. The response includes conflicting aliases in the list that occur
         * after the marker. To get the next page of the list, set this field’s value to the value
         * of NextMarker from the current page’s response.
         */
        fun marker(marker: String): FluentBuilder
        /**
         * The maximum number of conflicting aliases that you want in the response.
         */
        fun maxItems(maxItems: Int): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The alias (also called a CNAME) to search for conflicting aliases.
         */
        var alias: String?
        /**
         * The ID of a distribution in your account that has an attached SSL/TLS certificate that
         * includes the provided alias.
         */
        var distributionId: String?
        /**
         * Use this field when paginating results to indicate where to begin in the list of
         * conflicting aliases. The response includes conflicting aliases in the list that occur
         * after the marker. To get the next page of the list, set this field’s value to the value
         * of NextMarker from the current page’s response.
         */
        var marker: String?
        /**
         * The maximum number of conflicting aliases that you want in the response.
         */
        var maxItems: Int?

        fun build(): ListConflictingAliasesRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var alias: String? = null
        override var distributionId: String? = null
        override var marker: String? = null
        override var maxItems: Int? = null

        constructor(x: ListConflictingAliasesRequest) : this() {
            this.alias = x.alias
            this.distributionId = x.distributionId
            this.marker = x.marker
            this.maxItems = x.maxItems
        }

        override fun build(): ListConflictingAliasesRequest = ListConflictingAliasesRequest(this)
        override fun alias(alias: String): FluentBuilder = apply { this.alias = alias }
        override fun distributionId(distributionId: String): FluentBuilder = apply { this.distributionId = distributionId }
        override fun marker(marker: String): FluentBuilder = apply { this.marker = marker }
        override fun maxItems(maxItems: Int): FluentBuilder = apply { this.maxItems = maxItems }
    }
}
