// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model



class ListCachePoliciesRequest private constructor(builder: BuilderImpl) {
    /**
     * Use this field when paginating results to indicate where to begin in your list of
     * cache policies. The response includes cache policies in the list that occur after the
     * marker. To get the next page of the list, set this field’s value to the value of
     * NextMarker from the current page’s response.
     */
    val marker: String? = builder.marker
    /**
     * The maximum number of cache policies that you want in the response.
     */
    val maxItems: Int? = builder.maxItems
    /**
     * A filter to return only the specified kinds of cache policies. Valid values
     * are:
     * managed – Returns only the managed policies created by Amazon Web Services.
     * custom – Returns only the custom policies created in your account.
     */
    val type: CachePolicyType? = builder.type

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ListCachePoliciesRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ListCachePoliciesRequest(")
        append("marker=$marker,")
        append("maxItems=$maxItems,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = marker?.hashCode() ?: 0
        result = 31 * result + (maxItems ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ListCachePoliciesRequest

        if (marker != other.marker) return false
        if (maxItems != other.maxItems) return false
        if (type != other.type) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ListCachePoliciesRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ListCachePoliciesRequest
        /**
         * Use this field when paginating results to indicate where to begin in your list of
         * cache policies. The response includes cache policies in the list that occur after the
         * marker. To get the next page of the list, set this field’s value to the value of
         * NextMarker from the current page’s response.
         */
        fun marker(marker: String): FluentBuilder
        /**
         * The maximum number of cache policies that you want in the response.
         */
        fun maxItems(maxItems: Int): FluentBuilder
        /**
         * A filter to return only the specified kinds of cache policies. Valid values
         * are:
         * managed – Returns only the managed policies created by Amazon Web Services.
         * custom – Returns only the custom policies created in your account.
         */
        fun type(type: CachePolicyType): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Use this field when paginating results to indicate where to begin in your list of
         * cache policies. The response includes cache policies in the list that occur after the
         * marker. To get the next page of the list, set this field’s value to the value of
         * NextMarker from the current page’s response.
         */
        var marker: String?
        /**
         * The maximum number of cache policies that you want in the response.
         */
        var maxItems: Int?
        /**
         * A filter to return only the specified kinds of cache policies. Valid values
         * are:
         * managed – Returns only the managed policies created by Amazon Web Services.
         * custom – Returns only the custom policies created in your account.
         */
        var type: CachePolicyType?

        fun build(): ListCachePoliciesRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var marker: String? = null
        override var maxItems: Int? = null
        override var type: CachePolicyType? = null

        constructor(x: ListCachePoliciesRequest) : this() {
            this.marker = x.marker
            this.maxItems = x.maxItems
            this.type = x.type
        }

        override fun build(): ListCachePoliciesRequest = ListCachePoliciesRequest(this)
        override fun marker(marker: String): FluentBuilder = apply { this.marker = marker }
        override fun maxItems(maxItems: Int): FluentBuilder = apply { this.maxItems = maxItems }
        override fun type(type: CachePolicyType): FluentBuilder = apply { this.type = type }
    }
}
