// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model



/**
 * A complex type that specifies a list of Lambda@Edge functions associations for a cache
 * behavior.
 * If you want to invoke one or more Lambda@Edge functions triggered by requests that match the
 * PathPattern of the cache behavior, specify the applicable values for
 * Quantity and Items. Note that there can be up to 4
 * LambdaFunctionAssociation items in this list (one for each possible value of
 * EventType) and each EventType can be associated with only one function.
 * If you don't want to invoke any Lambda@Edge functions for the requests that match
 * PathPattern, specify 0 for Quantity and omit
 * Items.
 */
class LambdaFunctionAssociations private constructor(builder: BuilderImpl) {
    /**
     * Optional: A complex type that contains LambdaFunctionAssociation items
     * for this cache behavior. If Quantity is 0, you can omit Items.
     */
    val items: List<LambdaFunctionAssociation>? = builder.items
    /**
     * The number of Lambda@Edge function associations for this cache behavior.
     */
    val quantity: Int? = builder.quantity

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): LambdaFunctionAssociations = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("LambdaFunctionAssociations(")
        append("items=$items,")
        append("quantity=$quantity)")
    }

    override fun hashCode(): kotlin.Int {
        var result = items?.hashCode() ?: 0
        result = 31 * result + (quantity ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as LambdaFunctionAssociations

        if (items != other.items) return false
        if (quantity != other.quantity) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): LambdaFunctionAssociations = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): LambdaFunctionAssociations
        /**
         * Optional: A complex type that contains LambdaFunctionAssociation items
         * for this cache behavior. If Quantity is 0, you can omit Items.
         */
        fun items(items: List<LambdaFunctionAssociation>): FluentBuilder
        /**
         * The number of Lambda@Edge function associations for this cache behavior.
         */
        fun quantity(quantity: Int): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Optional: A complex type that contains LambdaFunctionAssociation items
         * for this cache behavior. If Quantity is 0, you can omit Items.
         */
        var items: List<LambdaFunctionAssociation>?
        /**
         * The number of Lambda@Edge function associations for this cache behavior.
         */
        var quantity: Int?

        fun build(): LambdaFunctionAssociations
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var items: List<LambdaFunctionAssociation>? = null
        override var quantity: Int? = null

        constructor(x: LambdaFunctionAssociations) : this() {
            this.items = x.items
            this.quantity = x.quantity
        }

        override fun build(): LambdaFunctionAssociations = LambdaFunctionAssociations(this)
        override fun items(items: List<LambdaFunctionAssociation>): FluentBuilder = apply { this.items = items }
        override fun quantity(quantity: Int): FluentBuilder = apply { this.quantity = quantity }
    }
}
