// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model



/**
 * A complex type that contains a Lambda@Edge function association.
 */
class LambdaFunctionAssociation private constructor(builder: BuilderImpl) {
    /**
     * Specifies the event type that triggers a Lambda@Edge function invocation. You can specify the following values:
     * viewer-request: The function executes when CloudFront receives a request from a viewer
     * and before it checks to see whether the requested object is in the edge cache.
     * origin-request: The function executes only when CloudFront sends a request to your
     * origin. When the requested object is in the edge cache, the function doesn't
     * execute.
     * origin-response: The function executes after CloudFront receives a response from the origin and
     * before it caches the object in the response. When the requested object is in the edge cache, the function doesn't execute.
     * viewer-response: The function executes before CloudFront returns the requested object to the viewer.
     * The function executes regardless of whether the object was already in the edge cache.
     * If the origin returns an HTTP status code other than HTTP 200 (OK), the function doesn't execute.
     */
    val eventType: EventType? = builder.eventType
    /**
     * A flag that allows a Lambda@Edge function to have read access to the body content. For more information,
     * see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/lambda-include-body-access.html">Accessing the Request Body by Choosing the
     * Include Body Option in the Amazon CloudFront Developer Guide.
     */
    val includeBody: Boolean? = builder.includeBody
    /**
     * The ARN of the Lambda@Edge function. You must specify the ARN of a function version; you can't specify an alias
     * or $LATEST.
     */
    val lambdaFunctionArn: String? = builder.lambdaFunctionArn

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): LambdaFunctionAssociation = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("LambdaFunctionAssociation(")
        append("eventType=$eventType,")
        append("includeBody=$includeBody,")
        append("lambdaFunctionArn=$lambdaFunctionArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = eventType?.hashCode() ?: 0
        result = 31 * result + (includeBody?.hashCode() ?: 0)
        result = 31 * result + (lambdaFunctionArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as LambdaFunctionAssociation

        if (eventType != other.eventType) return false
        if (includeBody != other.includeBody) return false
        if (lambdaFunctionArn != other.lambdaFunctionArn) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): LambdaFunctionAssociation = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): LambdaFunctionAssociation
        /**
         * Specifies the event type that triggers a Lambda@Edge function invocation. You can specify the following values:
         * viewer-request: The function executes when CloudFront receives a request from a viewer
         * and before it checks to see whether the requested object is in the edge cache.
         * origin-request: The function executes only when CloudFront sends a request to your
         * origin. When the requested object is in the edge cache, the function doesn't
         * execute.
         * origin-response: The function executes after CloudFront receives a response from the origin and
         * before it caches the object in the response. When the requested object is in the edge cache, the function doesn't execute.
         * viewer-response: The function executes before CloudFront returns the requested object to the viewer.
         * The function executes regardless of whether the object was already in the edge cache.
         * If the origin returns an HTTP status code other than HTTP 200 (OK), the function doesn't execute.
         */
        fun eventType(eventType: EventType): FluentBuilder
        /**
         * A flag that allows a Lambda@Edge function to have read access to the body content. For more information,
         * see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/lambda-include-body-access.html">Accessing the Request Body by Choosing the
         * Include Body Option in the Amazon CloudFront Developer Guide.
         */
        fun includeBody(includeBody: Boolean): FluentBuilder
        /**
         * The ARN of the Lambda@Edge function. You must specify the ARN of a function version; you can't specify an alias
         * or $LATEST.
         */
        fun lambdaFunctionArn(lambdaFunctionArn: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Specifies the event type that triggers a Lambda@Edge function invocation. You can specify the following values:
         * viewer-request: The function executes when CloudFront receives a request from a viewer
         * and before it checks to see whether the requested object is in the edge cache.
         * origin-request: The function executes only when CloudFront sends a request to your
         * origin. When the requested object is in the edge cache, the function doesn't
         * execute.
         * origin-response: The function executes after CloudFront receives a response from the origin and
         * before it caches the object in the response. When the requested object is in the edge cache, the function doesn't execute.
         * viewer-response: The function executes before CloudFront returns the requested object to the viewer.
         * The function executes regardless of whether the object was already in the edge cache.
         * If the origin returns an HTTP status code other than HTTP 200 (OK), the function doesn't execute.
         */
        var eventType: EventType?
        /**
         * A flag that allows a Lambda@Edge function to have read access to the body content. For more information,
         * see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/lambda-include-body-access.html">Accessing the Request Body by Choosing the
         * Include Body Option in the Amazon CloudFront Developer Guide.
         */
        var includeBody: Boolean?
        /**
         * The ARN of the Lambda@Edge function. You must specify the ARN of a function version; you can't specify an alias
         * or $LATEST.
         */
        var lambdaFunctionArn: String?

        fun build(): LambdaFunctionAssociation
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var eventType: EventType? = null
        override var includeBody: Boolean? = null
        override var lambdaFunctionArn: String? = null

        constructor(x: LambdaFunctionAssociation) : this() {
            this.eventType = x.eventType
            this.includeBody = x.includeBody
            this.lambdaFunctionArn = x.lambdaFunctionArn
        }

        override fun build(): LambdaFunctionAssociation = LambdaFunctionAssociation(this)
        override fun eventType(eventType: EventType): FluentBuilder = apply { this.eventType = eventType }
        override fun includeBody(includeBody: Boolean): FluentBuilder = apply { this.includeBody = includeBody }
        override fun lambdaFunctionArn(lambdaFunctionArn: String): FluentBuilder = apply { this.lambdaFunctionArn = lambdaFunctionArn }
    }
}
