// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model



/**
 * Contains information about the Amazon Kinesis data stream where you are sending
 * real-time log data.
 */
class KinesisStreamConfig private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Resource Name (ARN) of an Identity and Access Management (IAM) role that
     * CloudFront can use to send real-time log data to your Kinesis data stream.
     * For more information the IAM role, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-iam-role">Real-time log configuration IAM role in the
     * Amazon CloudFront Developer Guide.
     */
    val roleArn: String? = builder.roleArn
    /**
     * The Amazon Resource Name (ARN) of the Kinesis data stream where you are sending real-time
     * log data.
     */
    val streamArn: String? = builder.streamArn

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): KinesisStreamConfig = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("KinesisStreamConfig(")
        append("roleArn=$roleArn,")
        append("streamArn=$streamArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = roleArn?.hashCode() ?: 0
        result = 31 * result + (streamArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as KinesisStreamConfig

        if (roleArn != other.roleArn) return false
        if (streamArn != other.streamArn) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): KinesisStreamConfig = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): KinesisStreamConfig
        /**
         * The Amazon Resource Name (ARN) of an Identity and Access Management (IAM) role that
         * CloudFront can use to send real-time log data to your Kinesis data stream.
         * For more information the IAM role, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-iam-role">Real-time log configuration IAM role in the
         * Amazon CloudFront Developer Guide.
         */
        fun roleArn(roleArn: String): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the Kinesis data stream where you are sending real-time
         * log data.
         */
        fun streamArn(streamArn: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Resource Name (ARN) of an Identity and Access Management (IAM) role that
         * CloudFront can use to send real-time log data to your Kinesis data stream.
         * For more information the IAM role, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-iam-role">Real-time log configuration IAM role in the
         * Amazon CloudFront Developer Guide.
         */
        var roleArn: String?
        /**
         * The Amazon Resource Name (ARN) of the Kinesis data stream where you are sending real-time
         * log data.
         */
        var streamArn: String?

        fun build(): KinesisStreamConfig
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var roleArn: String? = null
        override var streamArn: String? = null

        constructor(x: KinesisStreamConfig) : this() {
            this.roleArn = x.roleArn
            this.streamArn = x.streamArn
        }

        override fun build(): KinesisStreamConfig = KinesisStreamConfig(this)
        override fun roleArn(roleArn: String): FluentBuilder = apply { this.roleArn = roleArn }
        override fun streamArn(streamArn: String): FluentBuilder = apply { this.streamArn = streamArn }
    }
}
