// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A key group.
 * A key group contains a list of public keys that you can use with <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">CloudFront signed URLs and signed cookies.
 */
class KeyGroup private constructor(builder: BuilderImpl) {
    /**
     * The identifier for the key group.
     */
    val id: String? = builder.id
    /**
     * The key group configuration.
     */
    val keyGroupConfig: KeyGroupConfig? = builder.keyGroupConfig
    /**
     * The date and time when the key group was last modified.
     */
    val lastModifiedTime: Instant? = builder.lastModifiedTime

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): KeyGroup = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("KeyGroup(")
        append("id=$id,")
        append("keyGroupConfig=$keyGroupConfig,")
        append("lastModifiedTime=$lastModifiedTime)")
    }

    override fun hashCode(): kotlin.Int {
        var result = id?.hashCode() ?: 0
        result = 31 * result + (keyGroupConfig?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as KeyGroup

        if (id != other.id) return false
        if (keyGroupConfig != other.keyGroupConfig) return false
        if (lastModifiedTime != other.lastModifiedTime) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): KeyGroup = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): KeyGroup
        /**
         * The identifier for the key group.
         */
        fun id(id: String): FluentBuilder
        /**
         * The key group configuration.
         */
        fun keyGroupConfig(keyGroupConfig: KeyGroupConfig): FluentBuilder
        /**
         * The date and time when the key group was last modified.
         */
        fun lastModifiedTime(lastModifiedTime: Instant): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The identifier for the key group.
         */
        var id: String?
        /**
         * The key group configuration.
         */
        var keyGroupConfig: KeyGroupConfig?
        /**
         * The date and time when the key group was last modified.
         */
        var lastModifiedTime: Instant?

        fun build(): KeyGroup
        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.KeyGroupConfig] inside the given [block]
         */
        fun keyGroupConfig(block: KeyGroupConfig.DslBuilder.() -> kotlin.Unit) {
            this.keyGroupConfig = KeyGroupConfig.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var id: String? = null
        override var keyGroupConfig: KeyGroupConfig? = null
        override var lastModifiedTime: Instant? = null

        constructor(x: KeyGroup) : this() {
            this.id = x.id
            this.keyGroupConfig = x.keyGroupConfig
            this.lastModifiedTime = x.lastModifiedTime
        }

        override fun build(): KeyGroup = KeyGroup(this)
        override fun id(id: String): FluentBuilder = apply { this.id = id }
        override fun keyGroupConfig(keyGroupConfig: KeyGroupConfig): FluentBuilder = apply { this.keyGroupConfig = keyGroupConfig }
        override fun lastModifiedTime(lastModifiedTime: Instant): FluentBuilder = apply { this.lastModifiedTime = lastModifiedTime }
    }
}
