// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model



/**
 * The InvalidationList complex type describes the list of invalidation
 * objects. For more information about invalidation, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Invalidation.html">Invalidating Objects (Web Distributions Only) in
 * the Amazon CloudFront Developer Guide.
 */
class InvalidationList private constructor(builder: BuilderImpl) {
    /**
     * A flag that indicates whether more invalidation batch requests remain to be listed. If
     * your results were truncated, you can make a follow-up pagination request using the
     * Marker request parameter to retrieve more invalidation batches in the
     * list.
     */
    val isTruncated: Boolean? = builder.isTruncated
    /**
     * A complex type that contains one InvalidationSummary element for each
     * invalidation batch created by the current account.
     */
    val items: List<InvalidationSummary>? = builder.items
    /**
     * The value that you provided for the Marker request parameter.
     */
    val marker: String? = builder.marker
    /**
     * The value that you provided for the MaxItems request parameter.
     */
    val maxItems: Int? = builder.maxItems
    /**
     * If IsTruncated is true, this element is present and contains
     * the value that you can use for the Marker request parameter to continue listing
     * your invalidation batches where they left off.
     */
    val nextMarker: String? = builder.nextMarker
    /**
     * The number of invalidation batches that were created by the current account.
     */
    val quantity: Int? = builder.quantity

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): InvalidationList = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("InvalidationList(")
        append("isTruncated=$isTruncated,")
        append("items=$items,")
        append("marker=$marker,")
        append("maxItems=$maxItems,")
        append("nextMarker=$nextMarker,")
        append("quantity=$quantity)")
    }

    override fun hashCode(): kotlin.Int {
        var result = isTruncated?.hashCode() ?: 0
        result = 31 * result + (items?.hashCode() ?: 0)
        result = 31 * result + (marker?.hashCode() ?: 0)
        result = 31 * result + (maxItems ?: 0)
        result = 31 * result + (nextMarker?.hashCode() ?: 0)
        result = 31 * result + (quantity ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as InvalidationList

        if (isTruncated != other.isTruncated) return false
        if (items != other.items) return false
        if (marker != other.marker) return false
        if (maxItems != other.maxItems) return false
        if (nextMarker != other.nextMarker) return false
        if (quantity != other.quantity) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): InvalidationList = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): InvalidationList
        /**
         * A flag that indicates whether more invalidation batch requests remain to be listed. If
         * your results were truncated, you can make a follow-up pagination request using the
         * Marker request parameter to retrieve more invalidation batches in the
         * list.
         */
        fun isTruncated(isTruncated: Boolean): FluentBuilder
        /**
         * A complex type that contains one InvalidationSummary element for each
         * invalidation batch created by the current account.
         */
        fun items(items: List<InvalidationSummary>): FluentBuilder
        /**
         * The value that you provided for the Marker request parameter.
         */
        fun marker(marker: String): FluentBuilder
        /**
         * The value that you provided for the MaxItems request parameter.
         */
        fun maxItems(maxItems: Int): FluentBuilder
        /**
         * If IsTruncated is true, this element is present and contains
         * the value that you can use for the Marker request parameter to continue listing
         * your invalidation batches where they left off.
         */
        fun nextMarker(nextMarker: String): FluentBuilder
        /**
         * The number of invalidation batches that were created by the current account.
         */
        fun quantity(quantity: Int): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A flag that indicates whether more invalidation batch requests remain to be listed. If
         * your results were truncated, you can make a follow-up pagination request using the
         * Marker request parameter to retrieve more invalidation batches in the
         * list.
         */
        var isTruncated: Boolean?
        /**
         * A complex type that contains one InvalidationSummary element for each
         * invalidation batch created by the current account.
         */
        var items: List<InvalidationSummary>?
        /**
         * The value that you provided for the Marker request parameter.
         */
        var marker: String?
        /**
         * The value that you provided for the MaxItems request parameter.
         */
        var maxItems: Int?
        /**
         * If IsTruncated is true, this element is present and contains
         * the value that you can use for the Marker request parameter to continue listing
         * your invalidation batches where they left off.
         */
        var nextMarker: String?
        /**
         * The number of invalidation batches that were created by the current account.
         */
        var quantity: Int?

        fun build(): InvalidationList
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var isTruncated: Boolean? = null
        override var items: List<InvalidationSummary>? = null
        override var marker: String? = null
        override var maxItems: Int? = null
        override var nextMarker: String? = null
        override var quantity: Int? = null

        constructor(x: InvalidationList) : this() {
            this.isTruncated = x.isTruncated
            this.items = x.items
            this.marker = x.marker
            this.maxItems = x.maxItems
            this.nextMarker = x.nextMarker
            this.quantity = x.quantity
        }

        override fun build(): InvalidationList = InvalidationList(this)
        override fun isTruncated(isTruncated: Boolean): FluentBuilder = apply { this.isTruncated = isTruncated }
        override fun items(items: List<InvalidationSummary>): FluentBuilder = apply { this.items = items }
        override fun marker(marker: String): FluentBuilder = apply { this.marker = marker }
        override fun maxItems(maxItems: Int): FluentBuilder = apply { this.maxItems = maxItems }
        override fun nextMarker(nextMarker: String): FluentBuilder = apply { this.nextMarker = nextMarker }
        override fun quantity(quantity: Int): FluentBuilder = apply { this.quantity = quantity }
    }
}
