// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model



/**
 * An invalidation batch.
 */
class InvalidationBatch private constructor(builder: BuilderImpl) {
    /**
     * A value that you specify to uniquely identify an invalidation request. CloudFront uses the
     * value to prevent you from accidentally resubmitting an identical request. Whenever you create
     * a new invalidation request, you must specify a new value for CallerReference and
     * change other values in the request as applicable. One way to ensure that the value of
     * CallerReference is unique is to use a timestamp, for example,
     * 20120301090000.
     * If you make a second invalidation request with the same value for
     * CallerReference, and if the rest of the request is the same, CloudFront doesn't
     * create a new invalidation request. Instead, CloudFront returns information about the invalidation
     * request that you previously created with the same CallerReference.
     * If CallerReference is a value you already sent in a previous invalidation
     * batch request but the content of any Path is different from the original request,
     * CloudFront returns an InvalidationBatchAlreadyExists error.
     */
    val callerReference: String? = builder.callerReference
    /**
     * A complex type that contains information about the objects that you want to invalidate.
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Invalidation.html#invalidation-specifying-objects">Specifying the Objects
     * to Invalidate in the Amazon CloudFront Developer Guide.
     */
    val paths: Paths? = builder.paths

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): InvalidationBatch = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("InvalidationBatch(")
        append("callerReference=$callerReference,")
        append("paths=$paths)")
    }

    override fun hashCode(): kotlin.Int {
        var result = callerReference?.hashCode() ?: 0
        result = 31 * result + (paths?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as InvalidationBatch

        if (callerReference != other.callerReference) return false
        if (paths != other.paths) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): InvalidationBatch = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): InvalidationBatch
        /**
         * A value that you specify to uniquely identify an invalidation request. CloudFront uses the
         * value to prevent you from accidentally resubmitting an identical request. Whenever you create
         * a new invalidation request, you must specify a new value for CallerReference and
         * change other values in the request as applicable. One way to ensure that the value of
         * CallerReference is unique is to use a timestamp, for example,
         * 20120301090000.
         * If you make a second invalidation request with the same value for
         * CallerReference, and if the rest of the request is the same, CloudFront doesn't
         * create a new invalidation request. Instead, CloudFront returns information about the invalidation
         * request that you previously created with the same CallerReference.
         * If CallerReference is a value you already sent in a previous invalidation
         * batch request but the content of any Path is different from the original request,
         * CloudFront returns an InvalidationBatchAlreadyExists error.
         */
        fun callerReference(callerReference: String): FluentBuilder
        /**
         * A complex type that contains information about the objects that you want to invalidate.
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Invalidation.html#invalidation-specifying-objects">Specifying the Objects
         * to Invalidate in the Amazon CloudFront Developer Guide.
         */
        fun paths(paths: Paths): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A value that you specify to uniquely identify an invalidation request. CloudFront uses the
         * value to prevent you from accidentally resubmitting an identical request. Whenever you create
         * a new invalidation request, you must specify a new value for CallerReference and
         * change other values in the request as applicable. One way to ensure that the value of
         * CallerReference is unique is to use a timestamp, for example,
         * 20120301090000.
         * If you make a second invalidation request with the same value for
         * CallerReference, and if the rest of the request is the same, CloudFront doesn't
         * create a new invalidation request. Instead, CloudFront returns information about the invalidation
         * request that you previously created with the same CallerReference.
         * If CallerReference is a value you already sent in a previous invalidation
         * batch request but the content of any Path is different from the original request,
         * CloudFront returns an InvalidationBatchAlreadyExists error.
         */
        var callerReference: String?
        /**
         * A complex type that contains information about the objects that you want to invalidate.
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Invalidation.html#invalidation-specifying-objects">Specifying the Objects
         * to Invalidate in the Amazon CloudFront Developer Guide.
         */
        var paths: Paths?

        fun build(): InvalidationBatch
        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.Paths] inside the given [block]
         */
        fun paths(block: Paths.DslBuilder.() -> kotlin.Unit) {
            this.paths = Paths.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var callerReference: String? = null
        override var paths: Paths? = null

        constructor(x: InvalidationBatch) : this() {
            this.callerReference = x.callerReference
            this.paths = x.paths
        }

        override fun build(): InvalidationBatch = InvalidationBatch(this)
        override fun callerReference(callerReference: String): FluentBuilder = apply { this.callerReference = callerReference }
        override fun paths(paths: Paths): FluentBuilder = apply { this.paths = paths }
    }
}
