// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model



/**
 * A complex type that controls the countries in which your content is distributed. CloudFront
 * determines the location of your users using MaxMind GeoIP databases.
 */
class GeoRestriction private constructor(builder: BuilderImpl) {
    /**
     * A complex type that contains a Location element for each country in which
     * you want CloudFront either to distribute your content (whitelist) or not distribute
     * your content (blacklist).
     * The Location element is a two-letter, uppercase country code for a country
     * that you want to include in your blacklist or whitelist. Include one
     * Location element for each country.
     * CloudFront and MaxMind both use ISO 3166 country codes. For the
     * current list of countries and the corresponding codes, see ISO 3166-1-alpha-2
     * code on the International Organization for Standardization website. You
     * can also refer to the country list on the CloudFront console, which includes both country names and
     * codes.
     */
    val items: List<String>? = builder.items
    /**
     * When geo restriction is enabled, this is the number of countries in your
     * whitelist or blacklist. Otherwise, when it is not enabled,
     * Quantity is 0, and you can omit Items.
     */
    val quantity: Int? = builder.quantity
    /**
     * The method that you want to use to restrict distribution of your content by
     * country:
     * none: No geo restriction is enabled, meaning access to content is not
     * restricted by client geo location.
     * blacklist: The Location elements specify the countries in
     * which you don't want CloudFront to distribute your content.
     * whitelist: The Location elements specify the countries in
     * which you want CloudFront to distribute your content.
     */
    val restrictionType: GeoRestrictionType? = builder.restrictionType

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): GeoRestriction = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("GeoRestriction(")
        append("items=$items,")
        append("quantity=$quantity,")
        append("restrictionType=$restrictionType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = items?.hashCode() ?: 0
        result = 31 * result + (quantity ?: 0)
        result = 31 * result + (restrictionType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as GeoRestriction

        if (items != other.items) return false
        if (quantity != other.quantity) return false
        if (restrictionType != other.restrictionType) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): GeoRestriction = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): GeoRestriction
        /**
         * A complex type that contains a Location element for each country in which
         * you want CloudFront either to distribute your content (whitelist) or not distribute
         * your content (blacklist).
         * The Location element is a two-letter, uppercase country code for a country
         * that you want to include in your blacklist or whitelist. Include one
         * Location element for each country.
         * CloudFront and MaxMind both use ISO 3166 country codes. For the
         * current list of countries and the corresponding codes, see ISO 3166-1-alpha-2
         * code on the International Organization for Standardization website. You
         * can also refer to the country list on the CloudFront console, which includes both country names and
         * codes.
         */
        fun items(items: List<String>): FluentBuilder
        /**
         * When geo restriction is enabled, this is the number of countries in your
         * whitelist or blacklist. Otherwise, when it is not enabled,
         * Quantity is 0, and you can omit Items.
         */
        fun quantity(quantity: Int): FluentBuilder
        /**
         * The method that you want to use to restrict distribution of your content by
         * country:
         * none: No geo restriction is enabled, meaning access to content is not
         * restricted by client geo location.
         * blacklist: The Location elements specify the countries in
         * which you don't want CloudFront to distribute your content.
         * whitelist: The Location elements specify the countries in
         * which you want CloudFront to distribute your content.
         */
        fun restrictionType(restrictionType: GeoRestrictionType): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A complex type that contains a Location element for each country in which
         * you want CloudFront either to distribute your content (whitelist) or not distribute
         * your content (blacklist).
         * The Location element is a two-letter, uppercase country code for a country
         * that you want to include in your blacklist or whitelist. Include one
         * Location element for each country.
         * CloudFront and MaxMind both use ISO 3166 country codes. For the
         * current list of countries and the corresponding codes, see ISO 3166-1-alpha-2
         * code on the International Organization for Standardization website. You
         * can also refer to the country list on the CloudFront console, which includes both country names and
         * codes.
         */
        var items: List<String>?
        /**
         * When geo restriction is enabled, this is the number of countries in your
         * whitelist or blacklist. Otherwise, when it is not enabled,
         * Quantity is 0, and you can omit Items.
         */
        var quantity: Int?
        /**
         * The method that you want to use to restrict distribution of your content by
         * country:
         * none: No geo restriction is enabled, meaning access to content is not
         * restricted by client geo location.
         * blacklist: The Location elements specify the countries in
         * which you don't want CloudFront to distribute your content.
         * whitelist: The Location elements specify the countries in
         * which you want CloudFront to distribute your content.
         */
        var restrictionType: GeoRestrictionType?

        fun build(): GeoRestriction
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var items: List<String>? = null
        override var quantity: Int? = null
        override var restrictionType: GeoRestrictionType? = null

        constructor(x: GeoRestriction) : this() {
            this.items = x.items
            this.quantity = x.quantity
            this.restrictionType = x.restrictionType
        }

        override fun build(): GeoRestriction = GeoRestriction(this)
        override fun items(items: List<String>): FluentBuilder = apply { this.items = items }
        override fun quantity(quantity: Int): FluentBuilder = apply { this.quantity = quantity }
        override fun restrictionType(restrictionType: GeoRestrictionType): FluentBuilder = apply { this.restrictionType = restrictionType }
    }
}
