// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model



/**
 * Contains configuration information and metadata about a CloudFront function.
 */
class FunctionSummary private constructor(builder: BuilderImpl) {
    /**
     * Contains configuration information about a CloudFront function.
     */
    val functionConfig: FunctionConfig? = builder.functionConfig
    /**
     * Contains metadata about a CloudFront function.
     */
    val functionMetadata: FunctionMetadata? = builder.functionMetadata
    /**
     * The name of the CloudFront function.
     */
    val name: String? = builder.name
    /**
     * The status of the CloudFront function.
     */
    val status: String? = builder.status

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): FunctionSummary = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("FunctionSummary(")
        append("functionConfig=$functionConfig,")
        append("functionMetadata=$functionMetadata,")
        append("name=$name,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = functionConfig?.hashCode() ?: 0
        result = 31 * result + (functionMetadata?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as FunctionSummary

        if (functionConfig != other.functionConfig) return false
        if (functionMetadata != other.functionMetadata) return false
        if (name != other.name) return false
        if (status != other.status) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): FunctionSummary = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): FunctionSummary
        /**
         * Contains configuration information about a CloudFront function.
         */
        fun functionConfig(functionConfig: FunctionConfig): FluentBuilder
        /**
         * Contains metadata about a CloudFront function.
         */
        fun functionMetadata(functionMetadata: FunctionMetadata): FluentBuilder
        /**
         * The name of the CloudFront function.
         */
        fun name(name: String): FluentBuilder
        /**
         * The status of the CloudFront function.
         */
        fun status(status: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Contains configuration information about a CloudFront function.
         */
        var functionConfig: FunctionConfig?
        /**
         * Contains metadata about a CloudFront function.
         */
        var functionMetadata: FunctionMetadata?
        /**
         * The name of the CloudFront function.
         */
        var name: String?
        /**
         * The status of the CloudFront function.
         */
        var status: String?

        fun build(): FunctionSummary
        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.FunctionConfig] inside the given [block]
         */
        fun functionConfig(block: FunctionConfig.DslBuilder.() -> kotlin.Unit) {
            this.functionConfig = FunctionConfig.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.FunctionMetadata] inside the given [block]
         */
        fun functionMetadata(block: FunctionMetadata.DslBuilder.() -> kotlin.Unit) {
            this.functionMetadata = FunctionMetadata.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var functionConfig: FunctionConfig? = null
        override var functionMetadata: FunctionMetadata? = null
        override var name: String? = null
        override var status: String? = null

        constructor(x: FunctionSummary) : this() {
            this.functionConfig = x.functionConfig
            this.functionMetadata = x.functionMetadata
            this.name = x.name
            this.status = x.status
        }

        override fun build(): FunctionSummary = FunctionSummary(this)
        override fun functionConfig(functionConfig: FunctionConfig): FluentBuilder = apply { this.functionConfig = functionConfig }
        override fun functionMetadata(functionMetadata: FunctionMetadata): FluentBuilder = apply { this.functionMetadata = functionMetadata }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun status(status: String): FluentBuilder = apply { this.status = status }
    }
}
