// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains metadata about a CloudFront function.
 */
class FunctionMetadata private constructor(builder: BuilderImpl) {
    /**
     * The date and time when the function was created.
     */
    val createdTime: Instant? = builder.createdTime
    /**
     * The Amazon Resource Name (ARN) of the function. The ARN uniquely identifies the
     * function.
     */
    val functionArn: String? = builder.functionArn
    /**
     * The date and time when the function was most recently updated.
     */
    val lastModifiedTime: Instant? = builder.lastModifiedTime
    /**
     * The stage that the function is in, either DEVELOPMENT or
     * LIVE.
     * When a function is in the DEVELOPMENT stage, you can test the function with
     * TestFunction, and update it with UpdateFunction.
     * When a function is in the LIVE stage, you can attach the function to a
     * distribution’s cache behavior, using the function’s ARN.
     */
    val stage: FunctionStage? = builder.stage

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): FunctionMetadata = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("FunctionMetadata(")
        append("createdTime=$createdTime,")
        append("functionArn=$functionArn,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("stage=$stage)")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdTime?.hashCode() ?: 0
        result = 31 * result + (functionArn?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (stage?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as FunctionMetadata

        if (createdTime != other.createdTime) return false
        if (functionArn != other.functionArn) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (stage != other.stage) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): FunctionMetadata = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): FunctionMetadata
        /**
         * The date and time when the function was created.
         */
        fun createdTime(createdTime: Instant): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the function. The ARN uniquely identifies the
         * function.
         */
        fun functionArn(functionArn: String): FluentBuilder
        /**
         * The date and time when the function was most recently updated.
         */
        fun lastModifiedTime(lastModifiedTime: Instant): FluentBuilder
        /**
         * The stage that the function is in, either DEVELOPMENT or
         * LIVE.
         * When a function is in the DEVELOPMENT stage, you can test the function with
         * TestFunction, and update it with UpdateFunction.
         * When a function is in the LIVE stage, you can attach the function to a
         * distribution’s cache behavior, using the function’s ARN.
         */
        fun stage(stage: FunctionStage): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The date and time when the function was created.
         */
        var createdTime: Instant?
        /**
         * The Amazon Resource Name (ARN) of the function. The ARN uniquely identifies the
         * function.
         */
        var functionArn: String?
        /**
         * The date and time when the function was most recently updated.
         */
        var lastModifiedTime: Instant?
        /**
         * The stage that the function is in, either DEVELOPMENT or
         * LIVE.
         * When a function is in the DEVELOPMENT stage, you can test the function with
         * TestFunction, and update it with UpdateFunction.
         * When a function is in the LIVE stage, you can attach the function to a
         * distribution’s cache behavior, using the function’s ARN.
         */
        var stage: FunctionStage?

        fun build(): FunctionMetadata
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var createdTime: Instant? = null
        override var functionArn: String? = null
        override var lastModifiedTime: Instant? = null
        override var stage: FunctionStage? = null

        constructor(x: FunctionMetadata) : this() {
            this.createdTime = x.createdTime
            this.functionArn = x.functionArn
            this.lastModifiedTime = x.lastModifiedTime
            this.stage = x.stage
        }

        override fun build(): FunctionMetadata = FunctionMetadata(this)
        override fun createdTime(createdTime: Instant): FluentBuilder = apply { this.createdTime = createdTime }
        override fun functionArn(functionArn: String): FluentBuilder = apply { this.functionArn = functionArn }
        override fun lastModifiedTime(lastModifiedTime: Instant): FluentBuilder = apply { this.lastModifiedTime = lastModifiedTime }
        override fun stage(stage: FunctionStage): FluentBuilder = apply { this.stage = stage }
    }
}
