// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model



/**
 * A list of CloudFront functions that are associated with a cache behavior in a CloudFront distribution.
 * CloudFront functions must be published to the LIVE stage to associate them with a
 * cache behavior.
 */
class FunctionAssociations private constructor(builder: BuilderImpl) {
    /**
     * The CloudFront functions that are associated with a cache behavior in a CloudFront distribution.  CloudFront
     * functions must be published to the LIVE stage to associate them with a
     * cache behavior.
     */
    val items: List<FunctionAssociation>? = builder.items
    /**
     * The number of CloudFront functions in the list.
     */
    val quantity: Int? = builder.quantity

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): FunctionAssociations = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("FunctionAssociations(")
        append("items=$items,")
        append("quantity=$quantity)")
    }

    override fun hashCode(): kotlin.Int {
        var result = items?.hashCode() ?: 0
        result = 31 * result + (quantity ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as FunctionAssociations

        if (items != other.items) return false
        if (quantity != other.quantity) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): FunctionAssociations = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): FunctionAssociations
        /**
         * The CloudFront functions that are associated with a cache behavior in a CloudFront distribution.  CloudFront
         * functions must be published to the LIVE stage to associate them with a
         * cache behavior.
         */
        fun items(items: List<FunctionAssociation>): FluentBuilder
        /**
         * The number of CloudFront functions in the list.
         */
        fun quantity(quantity: Int): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The CloudFront functions that are associated with a cache behavior in a CloudFront distribution.  CloudFront
         * functions must be published to the LIVE stage to associate them with a
         * cache behavior.
         */
        var items: List<FunctionAssociation>?
        /**
         * The number of CloudFront functions in the list.
         */
        var quantity: Int?

        fun build(): FunctionAssociations
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var items: List<FunctionAssociation>? = null
        override var quantity: Int? = null

        constructor(x: FunctionAssociations) : this() {
            this.items = x.items
            this.quantity = x.quantity
        }

        override fun build(): FunctionAssociations = FunctionAssociations(this)
        override fun items(items: List<FunctionAssociation>): FluentBuilder = apply { this.items = items }
        override fun quantity(quantity: Int): FluentBuilder = apply { this.quantity = quantity }
    }
}
