// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model



/**
 * A CloudFront function that is associated with a cache behavior in a CloudFront
 * distribution.
 */
class FunctionAssociation private constructor(builder: BuilderImpl) {
    /**
     * The event type of the function, either viewer-request or
     * viewer-response. You cannot use origin-facing event types
     * (origin-request and origin-response) with a CloudFront
     * function.
     */
    val eventType: EventType? = builder.eventType
    /**
     * The Amazon Resource Name (ARN) of the function.
     */
    val functionArn: String? = builder.functionArn

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): FunctionAssociation = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("FunctionAssociation(")
        append("eventType=$eventType,")
        append("functionArn=$functionArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = eventType?.hashCode() ?: 0
        result = 31 * result + (functionArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as FunctionAssociation

        if (eventType != other.eventType) return false
        if (functionArn != other.functionArn) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): FunctionAssociation = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): FunctionAssociation
        /**
         * The event type of the function, either viewer-request or
         * viewer-response. You cannot use origin-facing event types
         * (origin-request and origin-response) with a CloudFront
         * function.
         */
        fun eventType(eventType: EventType): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the function.
         */
        fun functionArn(functionArn: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The event type of the function, either viewer-request or
         * viewer-response. You cannot use origin-facing event types
         * (origin-request and origin-response) with a CloudFront
         * function.
         */
        var eventType: EventType?
        /**
         * The Amazon Resource Name (ARN) of the function.
         */
        var functionArn: String?

        fun build(): FunctionAssociation
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var eventType: EventType? = null
        override var functionArn: String? = null

        constructor(x: FunctionAssociation) : this() {
            this.eventType = x.eventType
            this.functionArn = x.functionArn
        }

        override fun build(): FunctionAssociation = FunctionAssociation(this)
        override fun eventType(eventType: EventType): FluentBuilder = apply { this.eventType = eventType }
        override fun functionArn(functionArn: String): FluentBuilder = apply { this.functionArn = functionArn }
    }
}
