// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model



/**
 * A complex data type of profiles for the field-level encryption.
 */
class FieldLevelEncryptionProfileConfig private constructor(builder: BuilderImpl) {
    /**
     * A unique number that ensures that the request can't be replayed.
     */
    val callerReference: String? = builder.callerReference
    /**
     * An optional comment for the field-level encryption profile. The comment cannot be longer
     * than 128 characters.
     */
    val comment: String? = builder.comment
    /**
     * A complex data type of encryption entities for the field-level encryption profile that include the public key ID, provider, and
     * field patterns for specifying which fields to encrypt with this key.
     */
    val encryptionEntities: EncryptionEntities? = builder.encryptionEntities
    /**
     * Profile name for the field-level encryption profile.
     */
    val name: String? = builder.name

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): FieldLevelEncryptionProfileConfig = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("FieldLevelEncryptionProfileConfig(")
        append("callerReference=$callerReference,")
        append("comment=$comment,")
        append("encryptionEntities=$encryptionEntities,")
        append("name=$name)")
    }

    override fun hashCode(): kotlin.Int {
        var result = callerReference?.hashCode() ?: 0
        result = 31 * result + (comment?.hashCode() ?: 0)
        result = 31 * result + (encryptionEntities?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as FieldLevelEncryptionProfileConfig

        if (callerReference != other.callerReference) return false
        if (comment != other.comment) return false
        if (encryptionEntities != other.encryptionEntities) return false
        if (name != other.name) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): FieldLevelEncryptionProfileConfig = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): FieldLevelEncryptionProfileConfig
        /**
         * A unique number that ensures that the request can't be replayed.
         */
        fun callerReference(callerReference: String): FluentBuilder
        /**
         * An optional comment for the field-level encryption profile. The comment cannot be longer
         * than 128 characters.
         */
        fun comment(comment: String): FluentBuilder
        /**
         * A complex data type of encryption entities for the field-level encryption profile that include the public key ID, provider, and
         * field patterns for specifying which fields to encrypt with this key.
         */
        fun encryptionEntities(encryptionEntities: EncryptionEntities): FluentBuilder
        /**
         * Profile name for the field-level encryption profile.
         */
        fun name(name: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A unique number that ensures that the request can't be replayed.
         */
        var callerReference: String?
        /**
         * An optional comment for the field-level encryption profile. The comment cannot be longer
         * than 128 characters.
         */
        var comment: String?
        /**
         * A complex data type of encryption entities for the field-level encryption profile that include the public key ID, provider, and
         * field patterns for specifying which fields to encrypt with this key.
         */
        var encryptionEntities: EncryptionEntities?
        /**
         * Profile name for the field-level encryption profile.
         */
        var name: String?

        fun build(): FieldLevelEncryptionProfileConfig
        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.EncryptionEntities] inside the given [block]
         */
        fun encryptionEntities(block: EncryptionEntities.DslBuilder.() -> kotlin.Unit) {
            this.encryptionEntities = EncryptionEntities.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var callerReference: String? = null
        override var comment: String? = null
        override var encryptionEntities: EncryptionEntities? = null
        override var name: String? = null

        constructor(x: FieldLevelEncryptionProfileConfig) : this() {
            this.callerReference = x.callerReference
            this.comment = x.comment
            this.encryptionEntities = x.encryptionEntities
            this.name = x.name
        }

        override fun build(): FieldLevelEncryptionProfileConfig = FieldLevelEncryptionProfileConfig(this)
        override fun callerReference(callerReference: String): FluentBuilder = apply { this.callerReference = callerReference }
        override fun comment(comment: String): FluentBuilder = apply { this.comment = comment }
        override fun encryptionEntities(encryptionEntities: EncryptionEntities): FluentBuilder = apply { this.encryptionEntities = encryptionEntities }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
    }
}
